/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.localab.LocalABDefine;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.http.DefaultNullCall;
import com.yy.appbase.http.GraceInterceptor;
import com.yy.appbase.http.HttpUtilsKt;
import com.yy.appbase.http.IHttpMetricMonitor;
import com.yy.appbase.http.IHttpRequestPreventDuplicater;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.IHttpRetryCallback;
import com.yy.appbase.http.INetOriginRespByteArrayHeaderCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.adapter.netfactory.CDNMetric;
import com.yy.appbase.http.adapter.netfactory.DownloadNetworkFactory;
import com.yy.appbase.http.cronet.manager.NetParam;
import com.yy.appbase.http.cronet.manager.NetParamImpl;
import com.yy.appbase.http.dns.HTTPDnsUtils;
import com.yy.appbase.http.duplicator.GracePreventDuplicatorMetricImpl;
import com.yy.appbase.http.duplicator.GraceTrimMemoryWatcher;
import com.yy.appbase.http.utils.LogUtil;
import com.yy.appbase.http.wrap.NetRequestImpl;
import com.yy.appbase.http.wrap.get.AbstractGetBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostByteProtoBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostFileBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostJsonBuilder;
import com.yy.appbase.http.wrap.post.AbstractPostStringBuilder;
import com.yy.appbase.http.ws.WsStatusDelegate;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.net.NetworkConnection;
import com.yy.base.okhttp.GraceWrapper;
import com.yy.base.okhttp.stat.NetStat;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.Callback;
import com.yy.grace.Dns;
import com.yy.grace.Grace;
import com.yy.grace.ILog;
import com.yy.grace.MediaType;
import com.yy.grace.MultipartBody;
import com.yy.grace.Request;
import com.yy.grace.RequestEventListener;
import com.yy.grace.Response;
import com.yy.grace.ResponseBody;
import com.yy.grace.RetryEventListener;
import com.yy.grace.StatEventListener;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.grace.networkinterceptor.flowdispatcher.util.HostUtil;
import com.yy.grace.networkinterceptor.ibigbossconfig.NetOnlineConfig;
import com.yy.grace.singlerequest.metric.UniqueRequestMetric;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.proto.callback.ICheckTokenListener;
import com.yy.mobile.http.BaseNetwork;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpUtil {
    static final String TAG = "HttpUtil";
    static final String TAG_RETURN_CHECK = "HttpUtil_ReturnCheck";
    private static final String NETWORK_CONFIG_JSON_NAME = "hago_network_json_config";
    private static final int ERROR_INFO_MAX_LEN = 200;
    public static final int HTTP_GET = 1;
    public static final int HTTP_POST = 2;
    static final String CONTENT_TYPE = "Content-Type";
    static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=utf-8";
    static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=utf-8";
    static final String APPLICATION_PROTO = "application/proto";
    static final MediaType TEXT_PLAIN_CHARSET_UTF_8_MediaType = MediaType.parse((String)"text/plain;charset=utf-8");
    static final MediaType APPLICATION_JSON_CHARSET_UTF_8_MediaType = MediaType.parse((String)"application/json; charset=utf-8");
    static final MediaType APPLICATION_PROTO_MediaType = MediaType.parse((String)"application/proto");
    private static final NetParam mTestNetParam = new NetParamImpl();
    private static volatile IHttpMetricMonitor sMetricCallBack;
    private static volatile ICheckTokenListener mICheckTokenListener;
    private static volatile IHttpRequestPreventDuplicater sRequestPreventDuplicater;
    private static volatile IHttpRequestSender sHttpRequestSender;
    private static volatile IHttpRetryCallback sRetryCallBack;
    private static int mTokenSwitch;
    private static NetOnlineConfig sNetOnlineConfig;
    private static volatile boolean sNetworkConfigFetched;

    public static void init() {
        new GraceTrimMemoryWatcher().registerNotify();
    }

    private static boolean enableReportMetricForCDNType(String bizType) {
        return StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.DOWNLOAD.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.IMAGELOADER.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.GENERAL_DOWNLOAD.group() + "")) || StringUtils.equalsIgnoreCase((String)bizType, (String)(BizScenc.VIDEO.group() + ""));
    }

    private static void initGrace() {
        YYTaskExecutor.execute(() -> SettingFlags.setBoolean((String)"GRACE_EXECUTOR_MATCH_B", (boolean)NewABDefine.GRACE_EXECUTOR_EXP.matchB()), (long)15000L);
        GraceWrapper.setNetworkConfigListener(HttpUtil::getNetworkConfigJson);
        GraceWrapper.setGraceWrapperDelegate((GraceWrapper.GraceWrapperDelegate)new GraceWrapper.GraceWrapperDelegate(){

            @Nullable
            public String getBackupUrl(String originUrl) {
                if (sRetryCallBack != null) {
                    sRetryCallBack.getBackUpUrl(originUrl);
                }
                return null;
            }

            public GraceWrapper.BaseGraceInterceptor getGraceInterceptor() {
                return HttpUtil.getGraceInterceptor();
            }

            public Dns getDns() {
                return HTTPDnsUtils.INSTANCE.getDns();
            }

            public RequestEventListener getRequestEventListener() {
                return HttpUtil.getGraceEventListener();
            }

            public StatEventListener getStatEventListener() {
                return HttpUtil.getGraceStatListener();
            }

            public UniqueRequestMetric getUniqueRequestMetric() {
                return new GracePreventDuplicatorMetricImpl();
            }

            public RetryEventListener getRetryEventListener() {
                return HttpUtil.getRetryEventListener();
            }

            public ILog getLog() {
                return HttpUtil.getGraceLog();
            }

            public void reportGraceGetPrematureLog(String logMessage, boolean isInMainProcess) {
                MLog.error((Object)HttpUtil.TAG, (String)("report get grace too early: " + logMessage), (Object[])new Object[0]);
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("perftype", "get_grace_premature");
                statContent.put("sfieldthree", logMessage);
                statContent.put("ifieldthree", isInMainProcess ? 0 : 1);
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }

    private static RetryEventListener getRetryEventListener() {
        return new RetryEventListener(){

            public void onRetrySuccess(String s) {
                if (sRetryCallBack != null) {
                    sRetryCallBack.onRetrySuccess(s);
                }
                MLog.error((Object)HttpUtil.TAG, (String)"originUrl %s retry success!", (Object[])new Object[]{s});
            }

            public void onRetryError(String s, Exception e) {
                if (sRetryCallBack != null) {
                    sRetryCallBack.onRetryError(s, e);
                }
            }

            public void onBackupUrlError(String s, Exception e) {
                if (sRetryCallBack != null) {
                    sRetryCallBack.onOriginError(s, e);
                }
            }
        };
    }

    private static GraceInterceptor getGraceInterceptor() {
        return new GraceInterceptor();
    }

    private static ILog getGraceLog() {
        return new ILog(){

            public void i(Object obj, String format, Object ... args) {
                MLog.info((Object)("Grace_" + obj), (String)format, (Object[])args);
            }

            public void d(Object obj, String format, Object ... args) {
                MLog.debug((Object)("Grace_" + obj), (String)format, (Object[])args);
            }

            public void e(Object obj, String format, Object ... args) {
                MLog.error((Object)("Grace_" + obj), (String)format, (Object[])args);
            }

            public void i(Object obj, String args) {
                MLog.info((Object)("Grace_" + obj), (String)args, (Object[])new Object[0]);
            }

            public void d(Object obj, String args) {
                MLog.debug((Object)("Grace_" + obj), (String)args, (Object[])new Object[0]);
            }

            public void e(Object obj, String args, Throwable e) {
                MLog.error((Object)("Grace_" + obj), (String)args, (Throwable)e, (Object[])new Object[0]);
            }
        };
    }

    private static StatEventListener getGraceStatListener() {
        return new StatEventListener(){

            public void stat(HashMap<String, String> statContent, String act) {
                String url;
                String string2 = url = statContent != null ? statContent.get("url") + "" : "";
                if (HttpUtil.enableReportHiido(url)) {
                    StatisContent statisContent = new StatisContent();
                    statisContent.put("act", act);
                    for (Map.Entry<String, String> entry : statContent.entrySet()) {
                        statisContent.put(entry.getKey(), entry.getValue());
                    }
                    if (!statisContent.containsKey("json_map")) {
                        IAB iab = NewABDefine.PRE_CONNECTION.getTest();
                        HashMap<String, String> map = new HashMap<String, String>(2);
                        if (iab != null) {
                            map.put("ab_preconn", iab.getHiidoValue());
                        }
                        map.put("ab_login_preconn", LocalABDefine.KEY_LOGIN_PRE_CONNECT.getTest().toString());
                        statisContent.put("json_map", JsonParser.toJson(map));
                    }
                    String value = statisContent.toString();
                    MLog.debug((Object)HttpUtil.TAG, (String)value, (Object[])new Object[0]);
                    HiidoStatis.reportContent((StatisContent)statisContent);
                }
                String bizType = statContent.get("biztype");
                String status = statContent.get("status");
                if (!StringUtils.equalsIgnoreCase((String)status, (String)"2") && HttpUtil.enableReportMetricForCDNType(bizType)) {
                    String useTime = statContent.get("temp_1") + "";
                    String code = "0";
                    if (StringUtils.equalsIgnoreCase((String)status, (String)"1")) {
                        code = statContent.get("code");
                    }
                    MLog.debug((Object)HttpUtil.TAG, (String)("metric code " + code + " status " + status + " bizType " + bizType), (Object[])new Object[0]);
                    String remoteIp = statContent.get("remoteip");
                    CDNMetric.onMetric(HostUtil.getHostInUrl((String)url), remoteIp, Long.parseLong(useTime), code, bizType);
                }
            }

            public boolean isSwitchOn() {
                return true;
            }
        };
    }

    private static RequestEventListener getGraceEventListener() {
        return new RequestEventListener(){

            public void onStart(Request.Group group2, int i, String s, String s1, Map<String, String> map) {
                if (sMetricCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sMetricCallBack.onStart(i, s, s1, map);
                    MLog.debug((Object)HttpUtil.TAG, (String)("metric onStart group " + group2 + " url " + s), (Object[])new Object[0]);
                }
            }

            public void onCancel(Request.Group group2, int i, String s, String s1, Map<String, String> map) {
                if (sMetricCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sMetricCallBack.onCancel(i, s, s1, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onCancel group " + group2 + " url " + s), (Object[])new Object[0]);
            }

            public void onFailure(Request.Group group2, int i, String s, String s1, Throwable throwable, Map<String, String> map) {
                if (sMetricCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sMetricCallBack.onFailure(i, s, s1, throwable, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onFailure group " + group2 + " url " + s + " e " + throwable), (Object[])new Object[0]);
            }

            public void onResponse(Request.Group group2, int i, String s, String s1, long l, Map<String, String> map) {
                if (sMetricCallBack != null && HttpUtil.enableReportMetric(group2)) {
                    sMetricCallBack.onResponse(i, s, s1, l, map);
                }
                MLog.debug((Object)HttpUtil.TAG, (String)("metric onResponse group " + group2 + " url " + s), (Object[])new Object[0]);
            }
        };
    }

    private static boolean enableReportMetric(Request.Group group2) {
        return group2 != BizScenc.DOWNLOAD && group2 != BizScenc.IMAGELOADER && group2 != BizScenc.VIDEO && group2 != BizScenc.GAME_SERVICE && group2 != BizScenc.GENERAL_DOWNLOAD && group2 != BizScenc.WEB && group2 != BizScenc.NORMAL_LOGIN && group2 != BizScenc.UDB;
    }

    private static boolean enableReportHiido(String url) {
        boolean enableReportHiidoWhite = SettingFlags.getBoolean((String)"key_enable_report_hiido_white", (boolean)true);
        if (!enableReportHiidoWhite) {
            return mTestNetParam.isNeedStatus();
        }
        boolean enableReportUrl = false;
        if (StringUtils.isNotEmpty((String)url)) {
            if (url.contains("i.ihago.net")) {
                enableReportUrl = true;
            } else if (url.contains("turnover.ihago.net")) {
                enableReportUrl = true;
            }
        }
        return mTestNetParam.isNeedStatus() || enableReportUrl;
    }

    public static synchronized void setNetworkConfigJson(final String json) {
        sNetworkConfigFetched = true;
        sNetOnlineConfig = (NetOnlineConfig)JsonParser.parseJsonObject((String)json, NetOnlineConfig.class);
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                FileStorageUtils.getInstance().saveToFile(true, json, HttpUtil.NETWORK_CONFIG_JSON_NAME);
            }
        });
    }

    public static synchronized NetOnlineConfig getNetworkConfigJson() {
        if (!sNetworkConfigFetched && sNetOnlineConfig == null) {
            String json = FileStorageUtils.getInstance().getStrFromFile(true, NETWORK_CONFIG_JSON_NAME);
            LogUtil.i("NetConfigDispatcher", "json = " + json);
            try {
                if (StringUtils.isEmpty((String)json)) {
                    json = UnifyConfig.INSTANCE.getLocalDefaultConfigJson(BssCode.NETWORK);
                    LogUtil.i("NetConfigDispatcher", "json is null retry parse json = " + json);
                }
                sNetOnlineConfig = (NetOnlineConfig)JsonParser.parseJsonObject((String)json, NetOnlineConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return sNetOnlineConfig;
    }

    public static void setHttpMetric(IHttpMetricMonitor callBack) {
        sMetricCallBack = callBack;
    }

    public static void setCheckTokenListener(ICheckTokenListener checkTokenListener) {
        mICheckTokenListener = checkTokenListener;
    }

    public static void setRequestPreventDuplicater(IHttpRequestPreventDuplicater preventDuplicater) {
        sRequestPreventDuplicater = preventDuplicater;
    }

    public static void setHttpRetryCallback(IHttpRetryCallback callback) {
        sRetryCallBack = callback;
    }

    public static AbstractGetBuilder get() {
        return NetRequestImpl.getInstance().get();
    }

    public static AbstractPostBuilder post() {
        return NetRequestImpl.getInstance().post();
    }

    public static AbstractPostStringBuilder postString() {
        return NetRequestImpl.getInstance().postString();
    }

    public static AbstractPostJsonBuilder postJson() {
        return NetRequestImpl.getInstance().postJson();
    }

    public static AbstractPostByteProtoBuilder postByteProto() {
        return NetRequestImpl.getInstance().postByteProto();
    }

    public static AbstractPostFileBuilder postFile() {
        return NetRequestImpl.getInstance().postFile();
    }

    public static <Data> void httpReq(String url, Map<String, String> param, int type2, INetRespCallback<Data> callback) {
        HttpUtil.httpReq(url, param, type2, callback, null);
    }

    public static void httpReqPostByteProto(String url, byte[] postContent, Map<String, String> head, INetOriginRespByteArrayHeaderCallback callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, APPLICATION_PROTO);
        HttpUtil.httpReq(url, postContent, null, 2, callback, head);
    }

    public static <Data> void httpReqPostString(String url, String postContent, Map<String, String> head, INetRespCallback<Data> callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, TEXT_PLAIN_CHARSET_UTF_8);
        HttpUtil.httpReq(url, postContent.getBytes(), null, 2, callback, head);
    }

    public static <Data> void httpReqPostForJson(String url, String postContent, Map<String, String> head, INetRespCallback<Data> callback) {
        if (head == null) {
            head = new HashMap<String, String>();
        }
        head.put(CONTENT_TYPE, APPLICATION_JSON_CHARSET_UTF_8);
        HttpUtil.httpReq(url, postContent.getBytes(), null, 2, callback, head);
    }

    public static <Data> void httpReq(String url, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        HttpUtil.httpReq(url, null, param, type2, callback, headDataToAdd);
    }

    private static <Data> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        if (url != null && !HttpUtil.checkToken(url, callback, headDataToAdd)) {
            return;
        }
        IHttpRequestPreventDuplicater requestPreventDuplicater = sRequestPreventDuplicater;
        if (requestPreventDuplicater != null) {
            if (sHttpRequestSender == null) {
                sHttpRequestSender = new IHttpRequestSender(){

                    @Override
                    public <T> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<T> callback, Map<String, String> headDataToAdd) {
                        HttpUtil._httpReq(url, postContent, param, type2, callback, headDataToAdd);
                    }
                };
            }
            requestPreventDuplicater.httpReq(url, postContent, param, type2, callback, headDataToAdd, sHttpRequestSender);
        } else {
            HttpUtil._httpReq(url, postContent, param, type2, callback, headDataToAdd);
        }
    }

    private static <Data> void _httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        HashMap<String, String> paramReal = new HashMap<String, String>();
        if (param != null) {
            paramReal.putAll(param);
        }
        HashMap<String, String> headReal = new HashMap<String, String>();
        if (headDataToAdd != null) {
            headReal.putAll(headDataToAdd);
        }
        HttpUtilsKt.Companion.httpReqReal(url, postContent, paramReal, type2, callback, headReal);
    }

    private static <Data> boolean checkToken(String url, INetRespCallback<Data> callback, Map<String, String> headDataToAdd) {
        if (callback != null && callback.needToken() && HttpUtil.checkTokenSwitch() && (mICheckTokenListener == null || !mICheckTokenListener.isTokenValid())) {
            if (SystemUtils.isShowEnvSetting() && mICheckTokenListener == null) {
                YYTaskExecutor.execute(() -> {
                    throw new RuntimeException("mICheckTokenListener is null!");
                });
            }
            MLog.warn((Object)TAG, (String)"token \u672a\u6709\u6548\uff0chttp \u4e0d\u80fd\u8bf7\u6c42:%s", (Object[])new Object[]{url});
            IllegalStateException e = new IllegalStateException("token \u672a\u6709\u6548\uff0chttp \u4e0d\u80fd\u8bf7\u6c42. " + url + (headDataToAdd == null ? "" : headDataToAdd.toString()));
            if (YYTaskExecutor.isMainThread()) {
                callback.onError(new DefaultNullCall(url), e, 100);
            } else {
                YYTaskExecutor.postToMainThread(() -> callback.onError(new DefaultNullCall(url), e, 100));
            }
            if (RuntimeContext.sIsDebuggable && AccountUtil.getUid() > 0L) {
                MLog.error((Object)TAG, (Throwable)e);
                YYTaskExecutor.execute(() -> {
                    throw e;
                });
            }
            return false;
        }
        return true;
    }

    private static boolean checkTokenSwitch() {
        if (mTokenSwitch == 0 && SettingFlags.containKey((String)"close_token_check")) {
            mTokenSwitch = SettingFlags.getBoolean((String)"close_token_check", (boolean)false) ? -1 : 1;
        }
        return mTokenSwitch != -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGetSyncForPing(String url) {
        String result = "";
        Response response = null;
        try {
            response = GraceWrapper.getGrace().newCall(new Request.Builder<ResponseBody>(){}.url(url).get().build()).execute();
            if (response.body() != null) {
                result = ((ResponseBody)response.body()).string();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (response != null && response.body() != null) {
                ((ResponseBody)response.body()).close();
            }
        }
        return result;
    }

    public static <Data> void httpReqEx(String url, Object data2, Map<String, String> params, int type2, INetRespCallback<Data> callback) {
        if (data2 != null) {
            Runnable command2 = () -> {
                String jsonStr = JsonParser.toJson((Object)data2);
                HashMap<String, String> paramTemp = params;
                if (paramTemp == null) {
                    paramTemp = new HashMap<String, String>();
                }
                paramTemp.put("data", jsonStr);
                HttpUtil.httpReq(url, paramTemp, type2, callback);
            };
            if (SettingFlags.getBoolean((String)"keynetopenthreadopt", (boolean)true)) {
                YYTaskExecutor.execute((Runnable)command2, (long)0L, (int)5);
            } else {
                YYTaskExecutor.execute((Runnable)command2);
            }
        } else {
            HttpUtil.httpReq(url, params, type2, callback);
        }
    }

    public static void downloadFile(String url, String path, @NonNull String md5, Callback<File> callback) {
        GraceWrapper.downloadFile((String)url, (String)path, (String)md5, callback);
    }

    public static void downloadFile(String url, String path, Callback<File> callback) {
        GraceWrapper.downloadFile((String)url, (String)path, callback);
    }

    public static void uploadFile(Grace newGrace, String url, long connectTimeMills, long readTimeMills, long writeTimeMills, Map<String, String> headers, List<MultipartBody.Part> uploadParts, Callback<String> callback) {
        GraceWrapper.upload((Grace)newGrace, (String)url, (long)connectTimeMills, (long)readTimeMills, (long)writeTimeMills, headers, uploadParts, callback);
    }

    static {
        mTokenSwitch = 0;
        sNetworkConfigFetched = false;
        HttpUtil.initGrace();
        WsStatusDelegate.init();
        BaseNetwork.setConnectionFactory((NetworkConnection.Factory)DownloadNetworkFactory.sDownloadNetworkFactory());
        NetStat.setOnNetStat(mTestNetParam::isNeedStatus);
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private final Class raw;
        private final Type[] args;

        public ParameterizedTypeImpl(Class raw, Type[] args) {
            this.raw = raw;
            this.args = args != null ? args : new Type[]{};
        }

        @Override
        public Type[] getActualTypeArguments() {
            return this.args;
        }

        @Override
        public Type getRawType() {
            return this.raw;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }
    }

    static interface IParseDataStatCallBack {
        public void onSuccess();

        public void onError();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RequestType {
    }
}

