/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.http;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.adapter.netfactory.GraceStreamFetcher;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.HeadersCreator;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.HardwareUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.grace.Headers;
import com.yy.grace.networkinterceptor.BizScenc;
import com.yy.hiyo.proto.ProtoExtendDelegate;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.ReliableBroadcastStrategy;
import com.yy.hiyo.proto.callback.ICheckTokenListener;
import com.yy.mobile.http.BaseNetwork;
import com.yy.yylite.commonbase.hiido.HiidoUtils;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CommonHttpHeader {
    public static final String NOT_REPLACE_CUSTOM_HEADER = "not_replace_custom_header";
    public static final String TAG = "CommonHttpHeader";
    private static String appVer;
    private static String deviceType;
    private static String netTye;
    private static String osType;
    private static String osVer;
    private static String deviceId;
    private static String lang;
    private static String sdkVer;
    private static volatile String authToken;
    private static volatile boolean hasLoginedBefore;
    private static volatile boolean sWsClientGzip;
    private static final ConcurrentHashMap<String, String> mHeader;
    private static final Map<String, String> mRevenueHeader;
    private static ICheckTokenListener mCheckTokenListener;
    public static final String KEY_X_AUTH_TOKEN = "X-Auth-Token";
    private static volatile boolean sHeadersInited;
    private static final String X_LAST_SEQID = "X-Last-Seqid";
    private static String encodeChannelId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void ensureHeadersInited() {
        if (sHeadersInited) {
            return;
        }
        MLog.info((Object)TAG, (String)"init Headers!", (Object[])new Object[0]);
        ConcurrentHashMap<String, String> concurrentHashMap = mHeader;
        synchronized (concurrentHashMap) {
            if (sHeadersInited) {
                return;
            }
            mHeader.put("X-App-Name", AppKeysDef.getAppName());
            mHeader.put("X-App-Ver", CommonHttpHeader.getHagoAppVer());
            mHeader.put("X-App-Real-Ver", CommonHttpHeader.getAppAppVer());
            if (RuntimeContext.isHagoPartySdk()) {
                mHeader.put("X-Osdk-Name", "hago");
                mHeader.put("X-Osdk-Ver", CommonHttpHeader.getHagoAppVer());
            }
            mHeader.put("X-OlaParty-Ver", CommonHttpHeader.getAppAppVer());
            mHeader.put("X-App-LastVer", RuntimeContext.getLastAppVersion());
            mHeader.put("X-DeviceId", CommonHttpHeader.getHagoDeviceId());
            mHeader.put("X-DeviceType", CommonHttpHeader.getDeviceType());
            mHeader.put("X-Client-Net", CommonHttpHeader.getNetTye());
            mHeader.put("X-OsType", CommonHttpHeader.getOsType());
            mHeader.put("X-Os-Ver", CommonHttpHeader.getOsVer());
            mHeader.put("X-Lang", CommonHttpHeader.getLang());
            mHeader.put(KEY_X_AUTH_TOKEN, CommonHttpHeader.getAuthToken());
            mHeader.put("X-Sdk-Ver", CommonHttpHeader.getSdkVer());
            mHeader.put("X-CpuArch", HardwareUtils.getSimpleFormatCpuArch());
            mHeader.put("X-SimCIso", CommonHttpHeader.getSimCountryIso());
            String channelId = CommonHttpHeader.getEncodeChannelId();
            if (StringUtils.isNotEmpty((String)channelId)) {
                mHeader.put("X-App-Channel", channelId);
            } else {
                MLog.info((Object)"ensureHeadersInited", (String)"X-App-Channel = null", (Object[])new Object[0]);
            }
            mRevenueHeader.put("X-App-Name", AppKeysDef.getAppName());
            mRevenueHeader.put("version", CommonHttpHeader.getHagoAppVer());
            mRevenueHeader.put("X-App-Real-Ver", CommonHttpHeader.getAppAppVer());
            if (RuntimeContext.isHagoPartySdk()) {
                mRevenueHeader.put("X-Osdk-Name", "hago");
                mRevenueHeader.put("X-Osdk-Ver", CommonHttpHeader.getHagoAppVer());
            }
            mRevenueHeader.put("X-OlaParty-Ver", CommonHttpHeader.getAppAppVer());
            mRevenueHeader.put("X-AppId", String.valueOf(1802));
            mRevenueHeader.put("X-AuthToken", CommonHttpHeader.getAuthToken());
            mRevenueHeader.put("X-AuthType", String.valueOf(3));
            mRevenueHeader.put("country", CommonHttpHeader.countryCode());
            mRevenueHeader.put("language", CommonHttpHeader.languageCode());
            mRevenueHeader.put("stype", "1");
            mRevenueHeader.put("hdid", CommonHttpHeader.getHagoDeviceId());
            mRevenueHeader.put("osVersion", CommonHttpHeader.getOsVer());
            mRevenueHeader.put("machine", CommonHttpHeader.getDeviceType());
            mRevenueHeader.put("X-SimCIso", CommonHttpHeader.getSimCountryIso());
            mRevenueHeader.put("packagename", AppKeysDef.getAppPackageName());
            sHeadersInited = true;
        }
        MLog.info((Object)TAG, (String)"init Headers end!", (Object[])new Object[0]);
    }

    public static void setHttpUtilCheckTokenListener() {
        if (AccountUtil.getUid() <= 0L) {
            CommonHttpHeader.ensureHeadersInited();
        }
        if (mCheckTokenListener != null) {
            HttpUtil.setCheckTokenListener(mCheckTokenListener);
        } else {
            mCheckTokenListener = new ICheckTokenListener(){

                public boolean isTokenValid() {
                    return AccountUtil.getUid() > 0L && !TextUtils.isEmpty((CharSequence)authToken);
                }
            };
            HttpUtil.setCheckTokenListener(mCheckTokenListener);
        }
        MLog.info((Object)TAG, (String)"setHttpUtilCheckTokenListener!", (Object[])new Object[0]);
    }

    private static String getEncodeChannelId() {
        if (StringUtils.isNotEmpty((String)encodeChannelId)) {
            return encodeChannelId;
        }
        String channelId = AppMetaDataUtil.getChannelID((Context)RuntimeContext.sApplicationContext);
        encodeChannelId = URLUtils.urlEncoderEncode((String)channelId);
        return encodeChannelId;
    }

    @NonNull
    public static Map<String, String> getRevenueHeaderMap() {
        CommonHttpHeader.ensureHeadersInited();
        return new HashMap<String, String>(mRevenueHeader);
    }

    @NonNull
    public static Map<String, String> getRevenueHeaderMap(String countryCode) {
        CommonHttpHeader.ensureHeadersInited();
        HashMap<String, String> header = new HashMap<String, String>(mRevenueHeader);
        if (!TextUtils.isEmpty((CharSequence)countryCode)) {
            header.put("country", countryCode.toUpperCase());
        }
        return header;
    }

    public static boolean checkHttpHeaderUpdate(String url, String host, Object requestTag, Map<String, String> addMap, List<String> removeMap, String originHeaderString, int group2) {
        CommonHttpHeader.ensureHeadersInited();
        String key = null;
        String value = null;
        for (Map.Entry<String, String> header : mHeader.entrySet()) {
            key = header.getKey();
            if (StringUtils.equal((String)KEY_X_AUTH_TOKEN, (String)key)) {
                value = header.getValue();
                if (StringUtils.isEmpty((String)value)) {
                    if (StringUtils.isNotEmpty((String)authToken)) {
                        value = authToken;
                    }
                    CommonHttpHeader.warnRequestLoginStatus(url, originHeaderString);
                }
                addMap.put(key, value);
                continue;
            }
            if (group2 == BizScenc.WEB.group()) continue;
            addMap.put(key, header.getValue());
        }
        if (CommonHttpHeader.isThirdHost(host)) {
            removeMap.add(KEY_X_AUTH_TOKEN);
        } else if (SettingFlags.getBoolean((String)"key_removetoken_by_host", (boolean)false) && !CommonHttpHeader.isOurHost(host)) {
            removeMap.add(KEY_X_AUTH_TOKEN);
            if (RuntimeContext.sIsDebuggable) {
                MLog.error((Object)TAG, (String)"url: %s is not Hago Host!", (Object[])new Object[]{url});
            }
        }
        boolean needReplaceHttp = true;
        if (requestTag instanceof GraceStreamFetcher.ImageRequestTag) {
            removeMap.add(KEY_X_AUTH_TOKEN);
            needReplaceHttp = false;
            MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{"image"});
        } else if (requestTag instanceof BaseNetwork.RequestTag) {
            if (url.startsWith("http://")) {
                removeMap.add(KEY_X_AUTH_TOKEN);
                MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
            }
            needReplaceHttp = false;
        } else if (url.startsWith("http://") && (url.endsWith(".pkg") || url.endsWith(".patch"))) {
            removeMap.add(KEY_X_AUTH_TOKEN);
            needReplaceHttp = false;
            MLog.debug((Object)TAG, (String)"remove X-Auth-Token %s!", (Object[])new Object[]{url});
        } else if (SystemUtils.isShowEnvSetting() && url.startsWith("http://project.sysop.duowan.com")) {
            needReplaceHttp = false;
        }
        if (group2 == BizScenc.HTTP_RPC.group() || group2 == BizScenc.HTTP_SERVICE.group() || group2 == BizScenc.UDB.group() || group2 == BizScenc.NORMAL_LOGIN.group()) {
            long startTime = -1L;
            if (RuntimeContext.sIsDebuggable) {
                startTime = System.currentTimeMillis();
            }
            String pcid = ProtoExtendDelegate.getPcid();
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)("start get pcid time " + startTime + " pcid " + pcid + " url " + url), (Object[])new Object[0]);
            }
            if (StringUtils.isNotEmpty((String)pcid)) {
                addMap.put("X-Pcid", pcid);
            }
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)("get pcid use time " + (System.currentTimeMillis() - startTime) + " pcid " + pcid + " url " + url), (Object[])new Object[0]);
            }
        }
        return needReplaceHttp;
    }

    public static void fillHttpHeaderMap(String url, Map<String, String> map, Map<String, String> originalHeaders) {
        CommonHttpHeader.ensureHeadersInited();
        if (map == null) {
            return;
        }
        map.putAll(mHeader);
        String key = null;
        String value = null;
        for (Map.Entry<String, String> header : map.entrySet()) {
            key = header.getKey();
            if (!StringUtils.equal((String)KEY_X_AUTH_TOKEN, (String)key) || !StringUtils.isEmpty((String)(value = header.getValue()))) continue;
            if (StringUtils.isNotEmpty((String)authToken)) {
                value = authToken;
                map.put(key, value);
            }
            CommonHttpHeader.warnRequestLoginStatus(url, originalHeaders == null ? "" : originalHeaders.toString());
        }
        try {
            URL uri = new URL(url);
            if (CommonHttpHeader.isThirdHost(uri.getHost())) {
                map.remove(KEY_X_AUTH_TOKEN);
            } else if (SettingFlags.getBoolean((String)"key_removetoken_by_host", (boolean)false) && !CommonHttpHeader.isOurHost(uri.getHost())) {
                map.remove(KEY_X_AUTH_TOKEN);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.error((Object)TAG, (String)"url:%s is not Hago Host!", (Object[])new Object[]{url});
                }
            }
        }
        catch (MalformedURLException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public static boolean isThirdHost(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return false;
        }
        for (String item : UriProvider.THIRD_HOSTS) {
            if (item == null || !host.endsWith(item)) continue;
            return true;
        }
        return false;
    }

    private static boolean isOurHost(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return false;
        }
        return URLUtils.isOurHost((String)host);
    }

    private static void warnRequestLoginStatus(String url, String originalHeaders) {
        if (RuntimeContext.sIsDebuggable) {
            if (AccountUtil.getUid() > 0L) {
                throw new RuntimeException("lllllllllllllllllll:" + url + ", originalHeaders: " + originalHeaders);
            }
            if (!(url == null || !url.startsWith("https://") || url.contains(UriProvider.getLoginHost()) || url.contains(UriProvider.getNonLoginReportUrl()) || url.contains("web/appconfig") || url.contains("uinfo/get_uinfo_byver") || url.contains("boss_config/get"))) {
                if (!hasLoginedBefore) {
                    MLog.error((Object)"Warn", (Throwable)new RuntimeException("\u672a\u767b\u5f55\u53d1\u8d77\u4e86\u975e\u767b\u5f55\u76f8\u5173\u7684\u8bf7\u6c42:" + url + ", originalHeaders: " + originalHeaders));
                } else {
                    MLog.error((Object)"Warn", (Throwable)new RuntimeException("\u672a\u767b\u5f55\u53d1\u8d77\u4e86\u975e\u767b\u5f55\u76f8\u5173\u7684\u8bf7\u6c42:" + url + ", originalHeaders: " + originalHeaders));
                }
            }
        }
    }

    public static String getHagoAppVer() {
        return CommonHttpHeader.getHagoAppVerCode();
    }

    private static String getHagoAppVerCode() {
        return "41000";
    }

    public static String getHagoAppVerStr() {
        return "4.10.0";
    }

    public static String getAppAppVer() {
        if (TextUtils.isEmpty((CharSequence)appVer)) {
            appVer = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getVersionCodeWithoutSnapshot();
            MLog.info((Object)TAG, (String)"appVer:%s", (Object[])new Object[]{appVer});
        }
        return appVer != null ? appVer : "";
    }

    public static String getHagoDeviceId() {
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = HiidoUtils.getHdid();
            MLog.info((Object)TAG, (String)"device id:%s", (Object[])new Object[]{deviceId});
        }
        return deviceId != null ? deviceId : "";
    }

    private static String encodeHeadInfo(String headInfo) {
        StringBuffer stringBuffer = new StringBuffer();
        int length = headInfo.length();
        for (int i = 0; i < length; ++i) {
            char c = headInfo.charAt(i);
            if (c <= '\u001f' || c >= '\u007f') {
                stringBuffer.append(String.format("\\u%04x", c));
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getDeviceType() {
        if (TextUtils.isEmpty((CharSequence)deviceType)) {
            deviceType = CommonHttpHeader.encodeHeadInfo(Build.MANUFACTURER + " " + Build.MODEL);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    MLog.error((Object)CommonHttpHeader.TAG, (String)"getDeviceType:%s appVer:%s osVer:%s Lang:%s deviceID:%s sLastVer:%s", (Object[])new Object[]{deviceType, appVer, osVer, lang, deviceId, RuntimeContext.getLastAppVersion()});
                }
            }, (long)5000L);
        }
        return deviceType != null ? deviceType : "";
    }

    private static String getNetTye() {
        if (TextUtils.isEmpty((CharSequence)netTye)) {
            netTye = String.valueOf(NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext));
        }
        return netTye != null ? netTye : "";
    }

    public static void setNetTye(int netTyeInt) {
        netTye = String.valueOf(netTyeInt);
        mHeader.put("X-Client-Net", String.valueOf(netTye));
    }

    public static String getOsType() {
        if (TextUtils.isEmpty((CharSequence)osType)) {
            osType = "android";
        }
        return osType;
    }

    public static String getOsVer() {
        if (TextUtils.isEmpty((CharSequence)osVer)) {
            osVer = Build.VERSION.RELEASE;
        }
        return osVer != null ? osVer : "";
    }

    public static String getLang() {
        if (TextUtils.isEmpty((CharSequence)lang)) {
            lang = SystemUtils.getLangAndCountry();
        }
        return lang != null ? lang : "";
    }

    public static void localeChanged() {
        lang = "";
        mHeader.put("X-Lang", CommonHttpHeader.getLang());
        mRevenueHeader.put("language", CommonHttpHeader.languageCode());
    }

    private static void resetLangAndCountry() {
        lang = SystemUtils.getLangAndCountry();
        mHeader.put("X-Lang", CommonHttpHeader.getLang());
    }

    public static String getAuthToken() {
        return authToken != null ? authToken : "";
    }

    public static void setAuthToken(String token) {
        authToken = token;
        mHeader.put(KEY_X_AUTH_TOKEN, authToken);
        mRevenueHeader.put("X-AuthToken", authToken);
        if (StringUtils.isNotEmpty((String)token)) {
            hasLoginedBefore = true;
        }
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)TAG, (String)" authToken %s", (Object[])new Object[]{authToken});
        }
    }

    public static String getSdkVer() {
        if (TextUtils.isEmpty((CharSequence)sdkVer)) {
            sdkVer = "" + Build.VERSION.SDK_INT;
        }
        return sdkVer != null ? sdkVer : "";
    }

    public static void setCountryCode() {
        mRevenueHeader.put("country", CommonHttpHeader.countryCode());
        CommonHttpHeader.resetLangAndCountry();
    }

    private static String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    private static String getSimCountryIso() {
        return SystemUtils.getSimCountryIso();
    }

    private static String languageCode() {
        String code = SystemUtils.getLang();
        if (code == null) {
            return "";
        }
        return code.toLowerCase();
    }

    static {
        authToken = "";
        hasLoginedBefore = false;
        sWsClientGzip = SettingFlags.getBoolean((String)"wsclientgzip", (boolean)true);
        mHeader = new ConcurrentHashMap();
        mRevenueHeader = new HashMap<String, String>(10);
        sHeadersInited = false;
        WsClient.setHeadersCreator((HeadersCreator)new HeadersCreator(){

            public Headers headers() {
                String channelId;
                CommonHttpHeader.ensureHeadersInited();
                HashMap<String, String> wsHeaders = new HashMap<String, String>(mHeader);
                if (sWsClientGzip) {
                    wsHeaders.put("Content-Encoding", "gzip");
                }
                if (StringUtils.isEmpty((String)((String)wsHeaders.get(CommonHttpHeader.KEY_X_AUTH_TOKEN))) && StringUtils.isNotEmpty((String)authToken)) {
                    wsHeaders.put(CommonHttpHeader.KEY_X_AUTH_TOKEN, authToken);
                }
                if (ReliableBroadcastStrategy.enableReliableBroadcast()) {
                    long seqId = ReliableBroadcastStrategy.getSeqId();
                    wsHeaders.put(CommonHttpHeader.X_LAST_SEQID, seqId + "");
                    MLog.debug((Object)CommonHttpHeader.TAG, (String)("enableReliableBroadcast true seqId " + seqId), (Object[])new Object[0]);
                }
                if (StringUtils.isNotEmpty((String)(channelId = CommonHttpHeader.getEncodeChannelId()))) {
                    wsHeaders.put("X-App-Channel", channelId);
                } else {
                    MLog.info((Object)"WsClient head", (String)"X-App-Channel = null", (Object[])new Object[0]);
                }
                return Headers.of(wsHeaders);
            }

            public String getCurToken() {
                return CommonHttpHeader.getAuthToken();
            }
        }, (boolean)sWsClientGzip);
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"LiteApplication", (String)"CommonHttpHeader end", (Object[])new Object[0]);
        }
        mCheckTokenListener = new ICheckTokenListener(){

            public boolean isTokenValid() {
                return AccountUtil.getUid() > 0L && !TextUtils.isEmpty((CharSequence)authToken);
            }
        };
        ProtoManager.setCheckTokenListener((ICheckTokenListener)mCheckTokenListener);
        encodeChannelId = null;
    }
}

