/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.envsetting;

import androidx.annotation.Keep;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.base.env.RuntimeContext;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;

@Keep
public class EnvSettings {
    private static volatile EnvSettings mEnv;
    private EnvSettingType mUriEnvValue = EnvSettingType.Product;
    private EnvSettingType mGameDownloadUrlEnvValue = EnvSettingType.Product;
    private boolean mTodayRegisteredTest = false;
    private String mEnterSchemeUri = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EnvSettings instance() {
        Class<EnvSettings> clazz = EnvSettings.class;
        synchronized (EnvSettings.class) {
            if (mEnv != null) return mEnv;
            Class<EnvSettings> clazz2 = EnvSettings.class;
            synchronized (EnvSettings.class) {
                if (mEnv != null) return mEnv;
                mEnv = new EnvSettings();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return mEnv;
            }
        }
    }

    public boolean enableEnvSettingChange() {
        return RuntimeContext.sIsDebuggable || SystemUtils.isShowEnvSetting();
    }

    public void init() {
        EnvSettingType defaultValue = !RuntimeContext.sIsDebuggable && !SystemUtils.isCpPackage() ? EnvSettingType.Product : EnvSettingType.Test;
        this.mUriEnvValue = this.getEnvSettingType("ENV_URI_SETTING", defaultValue);
        this.mGameDownloadUrlEnvValue = this.getEnvSettingType("ENV_GAME_DOWNLOAD_SETTING", EnvSettingType.Product);
        this.mTodayRegisteredTest = this.getEnvTodayRegisteredTest("ENV_TODAY_NEW_REGISTERED_SETTING", false);
        this.updateEnv();
    }

    private EnvSettingType getEnvSettingType(String key, EnvSettingType defaultValue) {
        int ordinal;
        EnvSettingType envSettingType = this.enableEnvSettingChange() ? ((ordinal = SettingFlags.getIntValue((String)key, (int)-1)) > -1 && ordinal < EnvSettingType.values().length ? EnvSettingType.values()[ordinal] : defaultValue) : EnvSettingType.Product;
        return envSettingType;
    }

    private boolean getEnvTodayRegisteredTest(String key, boolean defaultValue) {
        if (this.enableEnvSettingChange()) {
            return SettingFlags.getBoolean((String)key, (boolean)defaultValue);
        }
        return defaultValue;
    }

    private void updateEnv() {
        UriProvider.init(this.mUriEnvValue);
    }

    public void setUriEnvSettingValue(EnvSettingType uriSetting) {
        if (uriSetting != null && this.enableEnvSettingChange()) {
            SettingFlags.setIntValue((String)"ENV_URI_SETTING", (int)uriSetting.ordinal());
            this.mUriEnvValue = uriSetting;
            this.updateEnv();
            this.notifyUriEnvSettingChange();
        }
    }

    public void setUriEnvSettingValue(boolean isTest) {
        if (isTest) {
            this.setUriEnvSettingValue(EnvSettingType.Test);
        } else {
            this.setUriEnvSettingValue(EnvSettingType.Product);
        }
    }

    public void setGameDownloadUriEnvSettingValue(EnvSettingType uriSetting) {
        if (uriSetting != null && this.enableEnvSettingChange()) {
            SettingFlags.setIntValue((String)"ENV_GAME_DOWNLOAD_SETTING", (int)uriSetting.ordinal());
            this.mGameDownloadUrlEnvValue = uriSetting;
        }
    }

    private void notifyUriEnvSettingChange() {
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationIdDef.ENV_SETTINS_CHANGED));
    }

    public EnvSettingType getUriSettingValue() {
        return this.mUriEnvValue;
    }

    public EnvSettingType getGameDownloadUriSettingValue() {
        return this.mGameDownloadUrlEnvValue;
    }

    public void setHiidoEnv(boolean isOpen) {
        if (this.enableEnvSettingChange()) {
            SettingFlags.setBoolean((String)"ENV_HIIDO_EVEN", (boolean)isOpen);
        }
    }

    public boolean getHiidoEnv() {
        if (this.enableEnvSettingChange()) {
            return SettingFlags.getBoolean((String)"ENV_HIIDO_EVEN", (boolean)false);
        }
        return false;
    }

    public void setAbTestEnv(boolean isOpen) {
        if (this.enableEnvSettingChange()) {
            SettingFlags.setBoolean((String)"ENV_ABTEST_EVEN", (boolean)isOpen);
        }
    }

    public int getWebUrlReplace() {
        if (this.enableEnvSettingChange()) {
            return SettingFlags.getIntValue((String)"ENV_WEB_URL_REPLACE", (int)0);
        }
        return 0;
    }

    public void setWebUrlReplace(int type2) {
        if (this.enableEnvSettingChange()) {
            SettingFlags.setIntValue((String)"ENV_WEB_URL_REPLACE", (int)type2);
        }
    }

    public boolean getAbTestEnv() {
        if (this.enableEnvSettingChange()) {
            return SettingFlags.getBoolean((String)"ENV_ABTEST_EVEN", (this.mUriEnvValue == EnvSettingType.Test ? 1 : 0) != 0) || SettingFlags.getBoolean((String)"ENV_ABTEST_EVEN", (this.mUriEnvValue == EnvSettingType.Dev ? 1 : 0) != 0);
        }
        return false;
    }

    public boolean getEnvAdSwitch() {
        if (!this.enableEnvSettingChange()) {
            return true;
        }
        return SettingFlags.getBoolean((String)"envadswitch", (boolean)true);
    }

    public void setTodayRegistered(boolean testMode) {
        if (this.enableEnvSettingChange()) {
            SettingFlags.setBoolean((String)"ENV_TODAY_NEW_REGISTERED_SETTING", (boolean)testMode);
            this.mTodayRegisteredTest = testMode;
        }
    }

    public boolean isTodayRegisteredTest() {
        return this.mTodayRegisteredTest;
    }

    public boolean isTestMode() {
        return RuntimeContext.sIsDebuggable && this.mUriEnvValue == EnvSettingType.Test;
    }

    public void setEnterSchemeUri(String enterSchemeUri) {
        if (SystemUtils.isShowEnvSetting()) {
            this.mEnterSchemeUri = enterSchemeUri;
        }
    }

    public String getEnterSchemeUri() {
        return this.mEnterSchemeUri;
    }
}

