/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.data;

import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.AgeRestrainConfig;
import com.yy.appbase.unifyconfig.config.BirthdayRegConfig;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlags;
import java.util.Calendar;

public class BirthdayDefines {
    private static final String TAG = "BirthdayDefines";
    public static final String DEFAULT_YEAR = "2000";
    public static final String DEFAULT_MONTH = "01";
    public static final String DEFAULT_DAY = "01";
    public static final String SPLIT = "-";
    public static final int DEFAULT_YEAR_INT = 2000;
    public static final int DEFAULT_MONTH_INT = 1;
    public static final int DEFAULT_DAY_INT = 1;

    public static String defaultBirthday() {
        AConfigData configData2 = UnifyConfig.INSTANCE.getConfigData(BssCode.BIRTHDAY_REG);
        int defaultAge = BirthdayRegConfig.Companion.getDEFAULT_AGE();
        if (configData2 instanceof BirthdayRegConfig) {
            BirthdayRegConfig birthdayRegConfig = (BirthdayRegConfig)configData2;
            defaultAge = birthdayRegConfig.getDefaultAge();
        }
        Calendar calendar = Calendar.getInstance();
        int nowYear = calendar.get(1);
        int year = nowYear - defaultAge;
        return BirthdayDefines.getDefaultYear() + SPLIT + "01" + SPLIT + "01";
    }

    public static int getDefaultYear() {
        int adjust = 0;
        String loginChannel = SettingFlags.getStringValue((String)"key_login_channel", (String)"other");
        if ("googlead".equals(loginChannel)) {
            adjust = 1;
        }
        AConfigData configData2 = UnifyConfig.INSTANCE.getConfigData(BssCode.BIRTHDAY_REG);
        int defaultAge = BirthdayRegConfig.Companion.getDEFAULT_AGE();
        if (configData2 instanceof BirthdayRegConfig) {
            BirthdayRegConfig birthdayRegConfig = (BirthdayRegConfig)configData2;
            defaultAge = birthdayRegConfig.getDefaultAge();
        }
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) - defaultAge - adjust;
    }

    public static int getAgeRestrain() {
        AgeRestrainConfig data2;
        AConfigData configData2 = UnifyConfig.INSTANCE.getConfigData(BssCode.AGE_RESTRAIN_CONFIG);
        if (configData2 == null) {
            MLog.info((Object)TAG, (String)"getAgeRestrain is null", (Object[])new Object[0]);
            UnifyConfig.INSTANCE.fetchConfigData(BssCode.AGE_RESTRAIN_CONFIG, null);
            UnifyConfig.INSTANCE.fetchConfigData(BssCode.BIRTHDAY_REG, null);
        }
        int age = 0;
        if (configData2 instanceof AgeRestrainConfig && (data2 = (AgeRestrainConfig)configData2).getAge() != 0) {
            age = data2.getAge();
        }
        return age;
    }
}

