/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.badger.impl;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.os.Bundle;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.badger.Badger;
import com.yy.base.logger.MLog;
import java.util.Arrays;
import java.util.List;

public class TranssionHomeBadger
implements Badger {
    private IAB mTest = null;

    @Override
    public void executeBadge(Context context, ComponentName componentName, int badgeCount) {
        if (this.mTest == null && NewABDefine.TRANSSION_BADGER_TEST.isValid()) {
            this.mTest = NewABDefine.TRANSSION_BADGER_TEST.getTest();
        }
        if (!NAB.A.equals(this.mTest)) {
            MLog.debug((Object)"TranssionHomeBadger", (String)"test not A, executeBadge ignore", (Object[])new Object[0]);
            return;
        }
        Bundle extraBundle = new Bundle();
        try {
            extraBundle.putString("package", context.getPackageName());
            extraBundle.putString("class", componentName.getClassName());
            extraBundle.putInt("badgenumber", badgeCount);
            if (this.getCurrentLauncher(context).contains("com.transsion.XOSLauncher")) {
                context.getContentResolver().call(Uri.parse((String)"content://com.transsion.XOSLauncher.unreadprovider"), "change_badge", null, extraBundle);
            } else if (this.getCurrentLauncher(context).contains("com.transsion.hilauncher")) {
                context.getContentResolver().call(Uri.parse((String)"content://com.transsion.hilauncher.unreadprovider"), "change_badge", null, extraBundle);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"TanssionHomeHomeBadger", (Throwable)e);
        }
    }

    private String getCurrentLauncher(Context context) {
        Intent intent = new Intent("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.HOME");
        ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 65536);
        return resolveInfo.activityInfo.packageName;
    }

    @Override
    public List<String> getSupportLaunchers() {
        return Arrays.asList("com.transsion.hilauncher", "com.transsion.XOSLauncher");
    }
}

