/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.account;

import android.os.Build;
import org.jetbrains.annotations.NotNull;

public enum LoginTypeData {
    INVALID("INVALID", -1),
    FACEBOOK("FACEBOOK", 1),
    PHONE("PHONE", 2),
    GOOGLE("GOOGLE", 3),
    LINE("LINE", 4),
    VK("VK", 5),
    RELOGIN("RELOGIN", 6),
    ZALO("ZALO", 7),
    WHATSAPP("WHATSAPP", 8),
    SNAPCHAT("SNAPCHAT", 9),
    GUEST("GUEST", 10),
    RELOGIN_SILENT("RELOGIN_SILENT", 11),
    HUAWEI("HUAWEI", 12);

    private String name;
    private int type;
    private boolean visible = true;

    private LoginTypeData(String name, int type2) {
        this.name = name;
        this.type = type2;
        if (this.type == 8) {
            this.visible = false;
        }
    }

    public boolean checkValid() {
        if (this == SNAPCHAT) {
            return Build.VERSION.SDK_INT >= 19;
        }
        return this != INVALID;
    }

    @NotNull
    public static LoginTypeData of(int type2) {
        LoginTypeData[] loginTypes;
        for (LoginTypeData loginType : loginTypes = LoginTypeData.values()) {
            if (loginType.type != type2) continue;
            if (!loginType.checkValid()) break;
            return loginType;
        }
        return INVALID;
    }

    @NotNull
    public static LoginTypeData of(String typeString) {
        try {
            return LoginTypeData.valueOf(typeString.toUpperCase());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return INVALID;
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type2) {
        this.type = type2;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public String toString() {
        return "LoginType{name=" + this.name + ", type=" + this.type + ", visible=" + this.visible + '}';
    }
}

