/*
 * Decompiled with CFR 0.152.
 */
package com.yy.appbase.abtest;

import com.google.gson.reflect.TypeToken;
import com.yy.appbase.abtest.ABConfig;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.abtest.BaseABDefine;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.IABConfig;
import com.yy.appbase.abtest.ReadAbTestConfigCallback;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.oldab.OAB;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseNewABDefine
extends BaseABDefine {
    private static final Type JSON_TYPE_OLD = new TypeToken<Map<String, OAB>>(){}.getType();
    private static final Type JSON_TYPE_NEW = new TypeToken<Map<String, NAB>>(){}.getType();
    private final Object fileLock = new Object();
    private final Map<String, IAB> mSaveResultMap = new ConcurrentHashMap<String, IAB>();
    private final AtomicLong mLastWriteTime = new AtomicLong(0L);
    private final CountDownLatch mReadLatch = new CountDownLatch(1);
    private final KvoBinder mBinder = new KvoBinder((Object)this);
    private final Runnable mWriteRunnable = new Runnable(){

        @Override
        public void run() {
            BaseNewABDefine.this.writeConfig();
        }
    };
    private final AtomicBoolean mReadFlag = new AtomicBoolean(false);
    private final Runnable mReadRunnable = new Runnable(){

        @Override
        public void run() {
            BaseNewABDefine.this.readConfig();
        }
    };

    public BaseNewABDefine() {
        this.setTag("NewABDefine");
        this.waitReadConfigHistory(new ReadAbTestConfigCallback(){

            @Override
            public void onReadFinish() {
                for (Map.Entry entry : BaseNewABDefine.this.mSaveResultMap.entrySet()) {
                    BaseNewABDefine.this.setABResult((String)entry.getKey(), (IAB)entry.getValue());
                }
            }
        });
    }

    @KvoMethodAnnotation(name="test", sourceClass=ABConfig.class, thread=2)
    void onUpdateTest(KvoEventIntent event) {
        if (event.isStickyNotify()) {
            return;
        }
        ABConfig config = (ABConfig)event.source();
        if (config != null) {
            MLog.debug((Object)this.mTag, (String)"onUpdateTest: %s, new test: %s, hiido value: %s", (Object[])new Object[]{config.getTestId(), config.getTestInner(), config.getHiidoValue()});
            IAB lastResult = this.mSaveResultMap.get(config.getTestId());
            if (config.isValid()) {
                Object newResult = config.getTestInner();
                if (lastResult == null || !lastResult.equals(newResult)) {
                    this.mSaveResultMap.put(config.getTestId(), (IAB)newResult);
                    this.checkWrite();
                }
            } else {
                this.mSaveResultMap.remove(config.getTestId());
                HiidoStatis.removeAbTestFlag((String[])new String[]{config.getTestId()});
                this.checkWrite();
            }
        }
    }

    public Set<ABConfig<IAB>> getABConfigSet() {
        HashSet<ABConfig<IAB>> result = new HashSet<ABConfig<IAB>>(this.mRecordMap.size());
        for (Map.Entry entry : this.mRecordMap.entrySet()) {
            IABConfig<?> config;
            BaseABDefine.ABTestRecord record = (BaseABDefine.ABTestRecord)entry.getValue();
            if (record == null || !((config = record.getConfig()) instanceof ABConfig)) continue;
            result.add((ABConfig)config);
        }
        return result;
    }

    @Override
    public void addConfig(@Nullable IABConfig<?> config) {
        super.addConfig(config);
        if (config instanceof KvoSource) {
            this.mBinder.singleBindSourceTo(config.getTestId(), (KvoSource)config);
        }
    }

    public void report(@NotNull IABConfig<?> config) {
        if (config.isValid()) {
            MLog.debug((Object)this.mTag, (String)("report ab config: " + config.getTestId()), (Object[])new Object[0]);
            ABTestManager.getInstance().reportLayerEvent(config.getTestId());
        }
    }

    private void setABResult(String testId, IAB abResult) {
        BaseABDefine.ABTestRecord record;
        if (abResult != null && (record = (BaseABDefine.ABTestRecord)this.mRecordMap.get(testId)) != null) {
            IABConfig<?> config = record.getConfig();
            MLog.debug((Object)this.mTag, (String)"setABResult testId: %s, result: %s", (Object[])new Object[]{testId, abResult});
            config.setTest(abResult);
        }
    }

    public void waitReadConfigHistory(final ReadAbTestConfigCallback callback) {
        MLog.debug((Object)this.mTag, (String)"wait read config history", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    if (!BaseNewABDefine.this.mReadFlag.getAndSet(true)) {
                        YYTaskExecutor.execute((Runnable)BaseNewABDefine.this.mReadRunnable, (long)200L);
                    }
                    BaseNewABDefine.this.mReadLatch.await();
                    MLog.debug((Object)BaseNewABDefine.this.mTag, (String)"read config history end", (Object[])new Object[0]);
                    if (callback != null) {
                        callback.onReadFinish();
                    }
                }
                catch (Exception ex) {
                    MLog.error((Object)BaseNewABDefine.this.mTag, (Throwable)ex);
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void readConfig() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void checkWrite() {
        YYTaskExecutor.removeTask((Runnable)this.mWriteRunnable);
        YYTaskExecutor.execute((Runnable)this.mWriteRunnable, (long)(System.currentTimeMillis() - this.mLastWriteTime.get() > 1000L ? 0L : 1000L));
    }

    public void clear() {
        this.mSaveResultMap.clear();
        this.writeConfig();
    }

    void writeConfig() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BaseNewABDefine.this.mLastWriteTime.set(System.currentTimeMillis());
                try {
                    String saveConfigString = JsonParser.toJson((Object)BaseNewABDefine.this.mSaveResultMap);
                    MLog.debug((Object)BaseNewABDefine.this.mTag, (String)("write ab config: " + saveConfigString), (Object[])new Object[0]);
                    Object object = BaseNewABDefine.this.fileLock;
                    synchronized (object) {
                        YYFileUtils.saveJsonData((String)saveConfigString, (String)BaseNewABDefine.this.getSaveConfigPath());
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)BaseNewABDefine.this.mTag, (Throwable)e);
                }
            }
        });
    }

    private String getSaveConfigPath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + File.separator + "abtest.txt";
    }
}

