/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.common.base.StringPrinter;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Formatter;
import com.diffplug.spotless.PaddedCellBulk;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.gradle.api.GradleException;

class PaddedCellGradle {
    private static final String URL = "https://github.com/diffplug/spotless/blob/master/PADDEDCELL.md";

    PaddedCellGradle() {
    }

    static GradleException youShouldTurnOnPaddedCell(SpotlessTask task) {
        Path rootPath = task.getProject().getRootDir().toPath();
        return new GradleException(StringPrinter.buildStringFromLines((String[])new String[]{"You have a misbehaving rule which can't make up its mind.", "This means that spotlessCheck will fail even after spotlessApply has run.", "", "This is a bug in a formatting rule, not Spotless itself, but Spotless can", "work around this bug and generate helpful bug reports for the broken rule", "if you add 'paddedCell()' to your build.gradle as such: ", "", "    spotless {", "        format 'someFormat', {", "            ...", "            paddedCell()", "        }", "    }", "", "The next time you run spotlessCheck, it will put helpful bug reports into", "'" + rootPath.relativize(PaddedCellGradle.diagnoseDir(task).toPath()) + "', and spotlessApply", "and spotlessCheck will be self-consistent from here on out.", "", "For details see https://github.com/diffplug/spotless/blob/master/PADDEDCELL.md"}));
    }

    private static File diagnoseDir(SpotlessTask task) {
        return new File(task.getProject().getBuildDir(), "spotless-diagnose-" + task.formatName());
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    static void check(SpotlessTask task, Formatter formatter, List<File> problemFiles) throws IOException {
        if (problemFiles.isEmpty()) {
            task.getLogger().info(StringPrinter.buildStringFromLines((String[])new String[]{task.getName() + " is in paddedCell() mode, but it doesn't need to be.", "If you remove that option, spotless will run ~2x faster.", "For details see https://github.com/diffplug/spotless/blob/master/PADDEDCELL.md"}));
        }
        File diagnoseDir = PaddedCellGradle.diagnoseDir(task);
        File rootDir = task.getProject().getRootDir();
        List stillFailing = PaddedCellBulk.check((File)rootDir, (File)diagnoseDir, (Formatter)formatter, problemFiles);
        if (!stillFailing.isEmpty()) {
            throw task.formatViolationsFor(formatter, problemFiles);
        }
    }
}

