/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.groovy;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class GrEclipseFormatterStep {
    private static final String NAME = "groovy eclipse formatter";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.groovy.GrEclipseFormatterStepImpl";
    private static final String FORMATTER_CLASS_OLD = "com.diffplug.gradle.spotless.groovy.eclipse.GrEclipseFormatterStepImpl";
    private static final String MAVEN_GROUP_ARTIFACT = "com.diffplug.spotless:spotless-eclipse-groovy";
    private static final String DEFAULT_VERSION = "4.13.0";
    private static final String FORMATTER_METHOD = "format";

    private GrEclipseFormatterStep() {
    }

    @Deprecated
    public static FormatterStep create(Iterable<File> settingsFiles, Provisioner provisioner) {
        return GrEclipseFormatterStep.create(GrEclipseFormatterStep.defaultVersion(), settingsFiles, provisioner);
    }

    @Deprecated
    public static FormatterStep create(String version, Iterable<File> settingsFiles, Provisioner provisioner) {
        EclipseBasedStepBuilder builder = GrEclipseFormatterStep.createBuilder(provisioner);
        builder.setVersion(version);
        builder.setPreferences(settingsFiles);
        return builder.build();
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)GrEclipseFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = GrEclipseFormatterStep.getClass(state);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static Class<?> getClass(EclipseBasedStepBuilder.State state) {
        if (state.getMavenCoordinate(MAVEN_GROUP_ARTIFACT).isPresent()) {
            return state.loadClass(FORMATTER_CLASS);
        }
        return state.loadClass(FORMATTER_CLASS_OLD);
    }
}

