/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ASTNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.ASTFragmentKind;
import org.codehaus.groovy.eclipse.codebrowsing.fragments.IASTFragment;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.codebrowsing.selection.FindSurroundingNode;
import org.codehaus.groovy.eclipse.core.compiler.GroovySnippetParser;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTVisitorDecorator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTTools {
    public static final int SPACE = 1;
    public static final int TAB = 2;

    public static Region getPositionOfBlockStatements(BlockStatement block) {
        Region methodStatements = new Region(0, 0);
        if (block.getStatements().size() > 0) {
            int endPosition;
            int startPosition;
            Expression exp;
            Statement firstStmt = block.getStatements().get(0);
            Statement lastStmt = block.getStatements().get(block.getStatements().size() - 1);
            if (firstStmt instanceof ReturnStatement && firstStmt.getLineNumber() == -1) {
                exp = ((ReturnStatement)firstStmt).getExpression();
                startPosition = exp.getStart();
            } else {
                startPosition = firstStmt.getStart();
            }
            if (lastStmt instanceof ReturnStatement && lastStmt.getLineNumber() == -1) {
                exp = ((ReturnStatement)lastStmt).getExpression();
                endPosition = exp.getEnd();
            } else {
                endPosition = lastStmt.getEnd();
            }
            methodStatements = new Region(startPosition, endPosition - startPosition);
        }
        return methodStatements;
    }

    public static boolean hasValidPosition(ASTNode node) {
        return node.getEnd() > 0;
    }

    public static String trimLeadingGap(String text) {
        return text.replaceFirst("[ \t\f]*", "");
    }

    public static String getLeadingGap(String text) {
        return text.replace(ASTTools.trimLeadingGap(text), "");
    }

    public static String setIndentationTo(String text, int intentation, int modus) {
        StringBuilder retString = new StringBuilder();
        String patternStr = ".+?(\n|\r\n|\r|\\z)";
        Pattern pattern = Pattern.compile(patternStr, 32);
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            String space;
            String line = matcher.group(0);
            int currentIntetnation = ASTTools.getCurrentIntentation(line);
            switch (modus) {
                case 1: {
                    space = "    ";
                    break;
                }
                default: {
                    space = "\t";
                }
            }
            int i = 0;
            while (i < currentIntetnation + intentation) {
                retString.append(space);
                ++i;
            }
            retString.append(ASTTools.trimLeadingGap(line));
        }
        return retString.toString();
    }

    public static int getCurrentIntentation(String line) {
        String leadingGap = ASTTools.getLeadingGap(line);
        int tabs = 0;
        int spaces = 0;
        int i = 0;
        while (i < leadingGap.length()) {
            switch (leadingGap.charAt(i)) {
                case '\t': {
                    ++tabs;
                    break;
                }
                case ' ': {
                    ++spaces;
                    break;
                }
            }
            ++i;
        }
        int currentIntetnation = tabs + spaces / 4;
        return currentIntetnation;
    }

    public static IDocument getDocumentWithSystemLineBreak(String text) {
        Document document = new Document();
        String linebreak = document.getDefaultLineDelimiter();
        document.set(text);
        try {
            int lineCount = document.getNumberOfLines();
            MultiTextEdit multiEdit = new MultiTextEdit();
            int i = 0;
            while (i < lineCount) {
                String delimiter = document.getLineDelimiter(i);
                if (delimiter != null && delimiter.length() > 0 && !delimiter.equals(linebreak)) {
                    IRegion region = document.getLineInformation(i);
                    multiEdit.addChild(new ReplaceEdit(region.getOffset() + region.getLength(), delimiter.length(), linebreak));
                }
                ++i;
            }
            multiEdit.apply(document);
        }
        catch (Exception exception) {}
        return document;
    }

    public static ModuleNode getASTNodeFromSource(String source) {
        GroovySnippetParser parser = new GroovySnippetParser();
        ModuleNode node = parser.parse(source);
        return node;
    }

    public static boolean hasMultipleReturnStatements(Statement statement) {
        ArrayList<ReturnStatement> returns = new ArrayList<ReturnStatement>();
        statement.visit(new FindReturns((List<ReturnStatement>)returns));
        return returns.size() > 1;
    }

    public static String getTextofNode(ASTNode node, IDocument document) {
        TextSelection sel = new TextSelection(document, node.getStart(), node.getEnd() - node.getStart());
        try {
            return document.get(sel.getOffset(), sel.getLength());
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    public static Set<Variable> getVariablesInScope(ModuleNode moduleNode, ASTNode node) {
        FindSurroundingNode find = new FindSurroundingNode(new Region(node), FindSurroundingNode.VisitKind.PARENT_STACK);
        find.doVisitSurroundingNode(moduleNode);
        ArrayList parentStack = new ArrayList(find.getParentStack());
        Collections.reverse(parentStack);
        HashSet<Variable> vars = new HashSet<Variable>();
        for (IASTFragment fragment : parentStack) {
            ASTNode astNode = fragment.getAssociatedNode();
            VariableScope scope = astNode instanceof BlockStatement ? ((BlockStatement)astNode).getVariableScope() : (astNode instanceof MethodNode ? ((MethodNode)astNode).getVariableScope() : (astNode instanceof ClosureExpression ? ((ClosureExpression)astNode).getVariableScope() : null));
            if (scope == null) continue;
            Iterator<Variable> declaredVariables = scope.getDeclaredVariablesIterator();
            while (declaredVariables.hasNext()) {
                vars.add(declaredVariables.next());
            }
        }
        return vars;
    }

    public static ClassNode getContainingClassNode(ModuleNode moduleNode, int offset) {
        ASTNode containingClassNode = null;
        ASTNode scriptClass = null;
        List<ClassNode> classes = moduleNode.getClasses();
        for (ClassNode clazz : classes) {
            if (clazz.isScript()) {
                scriptClass = clazz;
                continue;
            }
            if (clazz.getStart() > offset || clazz.getEnd() < offset) continue;
            containingClassNode = clazz;
        }
        if (containingClassNode == null) {
            containingClassNode = scriptClass != null && scriptClass.getStart() <= offset && scriptClass.getEnd() >= offset ? scriptClass : ASTNodeCompatibilityWrapper.getScriptClassDummy(moduleNode);
        } else {
            Iterator<InnerClassNode> innerClasses = ASTNodeCompatibilityWrapper.getInnerClasses(containingClassNode);
            while (innerClasses != null && innerClasses.hasNext()) {
                InnerClassNode inner = innerClasses.next();
                if (inner.getStart() > offset || inner.getEnd() < offset) continue;
                containingClassNode = inner;
                innerClasses = ASTNodeCompatibilityWrapper.getInnerClasses(inner);
            }
        }
        return containingClassNode;
    }

    public static IASTFragment getSelectionFragment(ModuleNode moduleNode, int selectionStart, int selectionLength) {
        FindSurroundingNode finder = new FindSurroundingNode(new Region(selectionStart, selectionLength), FindSurroundingNode.VisitKind.SURROUNDING_NODE);
        IASTFragment selectionFragment = null;
        IASTFragment fragment = finder.doVisitSurroundingNode(moduleNode);
        if (ASTFragmentKind.isExpressionKind((IASTFragment)fragment)) {
            selectionFragment = fragment;
        }
        return selectionFragment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindReturns
    extends ASTVisitorDecorator<List<ReturnStatement>> {
        public FindReturns(List<ReturnStatement> container) {
            super(container);
        }

        @Override
        public void visitReturnStatement(ReturnStatement statement) {
            ((List)this.container).add(statement);
            super.visitReturnStatement(statement);
        }
    }
}

