/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.impl.ReverseSourceBuffer;
import org.codehaus.groovy.eclipse.core.util.Token;
import org.codehaus.groovy.eclipse.core.util.TokenStreamException;

public class TokenStream {
    private static final Token TOKEN_EOF = new Token(0, -1, -1, null);
    private ISourceBuffer buffer;
    private int offset;
    private char ch;
    private Token last;
    private Token next = null;

    public TokenStream(ISourceBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.ch = buffer.charAt(offset);
    }

    public Token peek() throws TokenStreamException {
        int offset = this.offset;
        char ch = this.ch;
        Token last = this.last;
        Token next = this.next;
        Token ret = this.next();
        this.offset = offset;
        this.ch = ch;
        this.last = last;
        this.next = next;
        return ret;
    }

    public char getCurrentChar() {
        return this.ch;
    }

    public Token next() throws TokenStreamException {
        if (this.next != null) {
            this.last = this.next;
            this.next = null;
            return this.last;
        }
        if (this.offset == -1) {
            return TOKEN_EOF;
        }
        if (Character.isWhitespace(this.ch)) {
            this.skipWhite();
            if (this.offset == -1) {
                return TOKEN_EOF;
            }
        }
        if (this.isLineBreakChar()) {
            this.last = this.skipLineBreak();
            this.next = this.skipLineComment();
            return this.last;
        }
        if (this.ch == '/' && this.la(1) == '*') {
            this.last = this.scanBlockComment();
            return this.last;
        }
        if (Character.isJavaIdentifierPart(this.ch)) {
            this.last = this.scanIdent();
        } else {
            switch (this.ch) {
                case '.': {
                    this.last = this.scanDot();
                    break;
                }
                case ';': {
                    this.nextChar();
                    this.last = new Token(3, this.offset + 1, this.offset + 2, this.buffer.subSequence(this.offset + 1, this.offset + 2).toString());
                    break;
                }
                case '}': {
                    this.last = this.scanPair('{', '}', 6);
                    break;
                }
                case ')': {
                    this.last = this.scanPair('(', ')', 5);
                    break;
                }
                case ']': {
                    this.last = this.scanPair('[', ']', 7);
                    break;
                }
                case '\'': {
                    this.last = this.scanQuote('\'');
                    break;
                }
                case '\"': {
                    this.last = this.scanQuote('\"');
                    break;
                }
                default: {
                    throw new TokenStreamException(this.ch);
                }
            }
        }
        return this.last;
    }

    private Token scanDot() {
        this.nextChar();
        if (this.offset == -1) {
            return TOKEN_EOF;
        }
        if (this.ch == '.') {
            this.nextChar();
            return new Token(11, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        if (this.ch == '?') {
            this.nextChar();
            return new Token(12, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        if (this.ch == '*') {
            this.nextChar();
            return new Token(13, this.offset + 1, this.offset + 3, this.buffer.subSequence(this.offset + 1, this.offset + 3).toString());
        }
        return new Token(2, this.offset + 1, this.offset + 2, this.buffer.subSequence(this.offset + 1, this.offset + 2).toString());
    }

    private Token skipLineBreak() {
        int endOffset = this.offset + 1;
        char firstChar = this.ch;
        this.nextChar();
        if (this.offset != -1 && this.isLineBreakChar()) {
            char secondChar = this.ch;
            this.nextChar();
            return new Token(10, this.offset + 1, endOffset, new String(new char[]{firstChar, secondChar}));
        }
        return new Token(10, this.offset + 1, endOffset, new String(new char[]{firstChar}));
    }

    private boolean isLineBreakChar() {
        return this.ch == '\n' || this.ch == '\r';
    }

    public Token last() {
        return this.last;
    }

    private void nextChar() {
        if (this.offset == -1) {
            throw new IllegalStateException("tried to get next char after eof");
        }
        if (this.offset == 0) {
            this.offset = -1;
        } else {
            this.ch = this.buffer.charAt(--this.offset);
        }
    }

    private Token scanPair(char open, char close, int type) throws TokenStreamException {
        int endOffset = this.offset + 1;
        int pairCount = 1;
        while (pairCount > 0 && this.offset > 0) {
            this.ch = this.buffer.charAt(--this.offset);
            if (this.ch == open) {
                --pairCount;
                continue;
            }
            if (this.ch != close) continue;
            ++pairCount;
        }
        if (this.offset != 0) {
            this.ch = this.buffer.charAt(--this.offset);
        } else {
            this.offset = -1;
            if (pairCount != 0) {
                throw new TokenStreamException("Unclosed pair at EOF");
            }
        }
        return new Token(type, this.offset + 1, endOffset, this.buffer.subSequence(this.offset + 1, endOffset).toString());
    }

    private Token scanIdent() {
        int endOffset = this.offset + 1;
        do {
            this.nextChar();
        } while (this.offset > -1 && Character.isJavaIdentifierPart(this.ch));
        return new Token(1, this.offset + 1, endOffset, this.buffer.subSequence(this.offset + 1, endOffset).toString());
    }

    private Token scanQuote(char quote) throws TokenStreamException {
        Pattern tripleQuote;
        Pattern singleQuote;
        if (quote == '\'') {
            singleQuote = Pattern.compile("^'.*'");
            tripleQuote = Pattern.compile("^'''.*'''");
        } else {
            singleQuote = Pattern.compile("^\".*\"");
            tripleQuote = Pattern.compile("^\"\"\".*\"\"\"");
        }
        Token token = this.matchQuote(tripleQuote);
        if (token != null) {
            return token;
        }
        token = this.matchQuote(singleQuote);
        if (token != null) {
            return token;
        }
        throw new TokenStreamException("Could not close quoted string, end offset = " + this.offset);
    }

    private Token matchQuote(Pattern quotePattern) {
        ReverseSourceBuffer matchBuffer = new ReverseSourceBuffer(this.buffer, this.offset);
        Matcher matcher = quotePattern.matcher(matchBuffer);
        if (matcher.find()) {
            int startOffset;
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            this.offset = startOffset = this.offset - match.length() + 1;
            if (this.offset == 0) {
                this.offset = -1;
            }
            if (this.offset != -1) {
                --this.offset;
                this.ch = this.buffer.charAt(this.offset);
            }
            return new Token(4, startOffset, endOffset, match);
        }
        return null;
    }

    private void skipWhite() {
        if (this.isLineBreakChar()) {
            return;
        }
        do {
            this.nextChar();
        } while (Character.isWhitespace(this.ch) && !this.isLineBreakChar() && this.offset > -1);
    }

    private Token skipLineComment() {
        ReverseSourceBuffer matchBuffer = new ReverseSourceBuffer(this.buffer, this.offset);
        Pattern pattern = Pattern.compile(".*//");
        Matcher matcher = pattern.matcher(matchBuffer);
        if (matcher.find() && matcher.start() == 0) {
            int startOffset;
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            this.offset = startOffset = this.offset - match.length() + 1;
            this.ch = this.offset != 0 ? this.buffer.charAt(--this.offset) : this.buffer.charAt(this.offset--);
            return new Token(8, startOffset, endOffset, match);
        }
        return null;
    }

    private Token scanBlockComment() {
        ReverseSourceBuffer matchBuffer = new ReverseSourceBuffer(this.buffer, this.offset);
        Pattern pattern = Pattern.compile("(?s)/\\*.*\\*/");
        Matcher matcher = pattern.matcher(matchBuffer);
        if (matcher.find()) {
            int startOffset;
            String match = matcher.group(0);
            int endOffset = this.offset + 1;
            this.offset = startOffset = this.offset - match.length() + 1;
            this.ch = this.offset != 0 ? this.buffer.charAt(--this.offset) : this.buffer.charAt(this.offset--);
            return new Token(9, startOffset, endOffset, match);
        }
        this.ch = this.buffer.charAt(--this.offset);
        return null;
    }

    private char la(int index) {
        if (this.offset - index >= 0) {
            return this.buffer.charAt(this.offset - index);
        }
        return '\u0000';
    }
}

