/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.impl.StringSourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ParseException;
import org.codehaus.groovy.eclipse.core.util.Token;
import org.codehaus.groovy.eclipse.core.util.TokenStream;
import org.codehaus.groovy.eclipse.core.util.TokenStreamException;

public class ExpressionFinder {
    public String findForCompletions(ISourceBuffer sourceBuffer, int offset) throws ParseException {
        TokenStream stream;
        int endOffset;
        Token token;
        block17: {
            block16: {
                boolean offsetIsWhitespace;
                block15: {
                    boolean offsetIsQuote;
                    block14: {
                        token = null;
                        endOffset = 0;
                        stream = new TokenStream(sourceBuffer, offset);
                        token = stream.peek();
                        if (token.type != 0) break block14;
                        return null;
                    }
                    endOffset = token.endOffset;
                    offsetIsWhitespace = Character.isWhitespace(stream.getCurrentChar());
                    boolean bl = offsetIsQuote = stream.getCurrentChar() == '\"' || stream.getCurrentChar() == '\'';
                    if (!offsetIsQuote) break block15;
                    return null;
                }
                this.skipLineBreaksAndComments(stream);
                token = stream.next();
                if (!offsetIsWhitespace || token.type == 2 || token.type == 11 || token.type == 12 || token.type == 13) break block16;
                return "";
            }
            if (token.type != 0) break block17;
            return null;
        }
        try {
            switch (token.type) {
                case 2: 
                case 11: 
                case 12: 
                case 13: {
                    token = this.dot(stream);
                    break;
                }
                case 1: {
                    token = this.ident(stream);
                    break;
                }
                case 7: {
                    token = null;
                    break;
                }
                default: {
                    throw new ParseException(token);
                }
            }
        }
        catch (TokenStreamException tokenStreamException) {
            Token last = stream.last();
            if (last != null) {
                token = last;
            }
        }
        catch (IllegalStateException illegalStateException) {}
        if (token != null) {
            return sourceBuffer.subSequence(token.startOffset, endOffset).toString();
        }
        return "";
    }

    public int findTokenEnd(ISourceBuffer buffer, int initialOffset) {
        int candidate = initialOffset;
        while (buffer.length() > candidate) {
            if (!Character.isJavaIdentifierPart(buffer.charAt(candidate))) break;
            ++candidate;
        }
        return candidate;
    }

    public String[] splitForCompletion(String expression) {
        String[] split = this.splitForCompletionNoTrim(expression);
        if (split[0] != null) {
            split[0] = split[0].trim();
            if (split[0].startsWith("$")) {
                split[0] = split[0].substring(1);
            }
        }
        if (split[1] != null) {
            split[1] = split[1].trim();
            if (split[1].startsWith("$")) {
                split[1] = split[1].substring(1);
            }
        }
        return split;
    }

    public String[] splitForCompletionNoTrim(String expression) {
        String[] ret = new String[2];
        if (expression == null || expression.trim().length() < 1) {
            ret[0] = "";
            ret[1] = null;
            return ret;
        }
        StringSourceBuffer sb = new StringSourceBuffer(expression);
        TokenStream stream = new TokenStream(sb, expression.length() - 1);
        try {
            this.skipLineBreaksAndComments(stream);
            Token token0 = stream.next();
            this.skipLineBreaksAndComments(stream);
            Token token1 = stream.next();
            this.skipLineBreaksAndComments(stream);
            Token token2 = stream.next();
            if ((token0.type == 2 || token0.type == 12 || token0.type == 13) && this.isValidBeforeDot(token1.type)) {
                ret[0] = expression.substring(0, token1.endOffset);
                ret[1] = "";
            } else if (token0.type == 1 && (token1.type == 2 || token1.type == 12 || token1.type == 13) && this.isValidBeforeDot(token2.type)) {
                ret[0] = expression.substring(0, token2.endOffset);
                ret[1] = expression.substring(token0.startOffset, expression.length());
            } else if (token0.type == 1) {
                ret[0] = expression;
            } else {
                String[] stringArray = new String[2];
                stringArray[0] = "";
                ret = stringArray;
            }
        }
        catch (TokenStreamException tokenStreamException) {
            String[] stringArray = new String[2];
            stringArray[0] = "";
            ret = stringArray;
        }
        catch (IllegalStateException illegalStateException) {
            String[] stringArray = new String[2];
            stringArray[0] = "";
            ret = stringArray;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public NameAndLocation findPreviousTypeNameToken(ISourceBuffer buffer, int start) {
        current = start;
        --current;
        while (current >= 0 && !Character.isWhitespace(buffer.charAt(current)) && Character.isJavaIdentifierPart(buffer.charAt(current))) {
            --current;
        }
        if (current < 0 || !Character.isWhitespace(buffer.charAt(current))) {
            return null;
        }
        sb = new StringBuilder();
        while (current >= 0 && (Character.isWhitespace(buffer.charAt(current)) || buffer.charAt(current) == '[' || buffer.charAt(current) == ']') && buffer.charAt(current) != '\n' && buffer.charAt(current) != '\r') {
            sb.append(buffer.charAt(current--));
        }
        if (current >= 0 && Character.isJavaIdentifierPart(buffer.charAt(current))) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            sb.append(buffer.charAt(current--));
lbl17:
            // 2 sources

            ** while (current >= 0 && Character.isJavaIdentifierPart((char)buffer.charAt((int)current)))
        }
lbl18:
        // 1 sources

        if (sb.length() > 0) {
            return new NameAndLocation(sb.reverse().toString(), current + 1);
        }
        return null;
    }

    private void skipLineBreaksAndComments(TokenStream stream) throws TokenStreamException {
        this.skipLineBreaks(stream);
        this.skipLineComments(stream);
    }

    private boolean isValidBeforeDot(int type) {
        int[] beforeDot = new int[]{1, 4, 6, 7, 5};
        int i = 0;
        while (i < beforeDot.length) {
            if (type == beforeDot[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Token dot(TokenStream stream) throws TokenStreamException, ParseException {
        this.skipLineBreaksAndComments(stream);
        Token token = stream.next();
        switch (token.type) {
            case 1: {
                return this.ident(stream);
            }
            case 4: {
                return this.quotedString(stream);
            }
            case 5: {
                return this.parenBlock(stream);
            }
            case 6: {
                return this.braceBlock(stream);
            }
            case 7: {
                return this.brackBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private void skipLineComments(TokenStream stream) throws TokenStreamException {
        while (stream.peek().type == 8) {
            stream.next();
        }
    }

    private void skipLineBreaks(TokenStream stream) throws TokenStreamException {
        while (stream.peek().type == 10) {
            stream.next();
        }
    }

    private Token ident(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        Token last = stream.last();
        switch (token.type) {
            case 10: {
                this.skipLineBreaksAndComments(stream);
                token = stream.peek();
                if (token.type != 2 && token.type != 12 && token.type != 13) {
                    return new Token(0, last.startOffset, last.endOffset, null);
                }
                stream.next();
                return this.dot(stream);
            }
            case 11: {
                return new Token(0, last.startOffset, last.endOffset, null);
            }
            case 2: 
            case 12: 
            case 13: {
                stream.next();
                return this.dot(stream);
            }
            case 1: {
                if (!token.text.equals("new")) break;
                Token next = stream.next();
                return new Token(0, next.startOffset, next.endOffset, null);
            }
        }
        return new Token(0, last.startOffset, last.endOffset, null);
    }

    private Token quotedString(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.type) {
            case 0: 
            case 10: {
                Token last = stream.last();
                return new Token(0, last.startOffset, last.startOffset, null);
            }
            case 3: {
                Token last = stream.last();
                return new Token(0, last.startOffset, last.startOffset, null);
            }
            case 1: {
                Token last = stream.last();
                return new Token(0, last.startOffset, last.startOffset, null);
            }
        }
        throw new ParseException(token);
    }

    private Token parenBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.type) {
            case 1: {
                stream.next();
                return this.ident(stream);
            }
            case 0: 
            case 3: 
            case 10: {
                return stream.last();
            }
        }
        throw new ParseException(token);
    }

    private Token braceBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.next();
        switch (token.type) {
            case 1: {
                return this.ident(stream);
            }
            case 5: {
                return this.parenBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private Token brackBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token last = stream.last();
        Token token = stream.next();
        switch (token.type) {
            case 0: {
                return new Token(0, last.startOffset, last.startOffset, null);
            }
            case 1: {
                return this.ident(stream);
            }
            case 5: {
                return this.parenBlock(stream);
            }
            case 6: {
                return this.braceBlock(stream);
            }
            case 7: {
                return this.brackBlock(stream);
            }
            case 3: 
            case 10: {
                return stream.last();
            }
        }
        throw new ParseException(token);
    }

    public class NameAndLocation {
        public final String name;
        public final int location;

        public NameAndLocation(String name, int locaiton) {
            this.name = name;
            this.location = locaiton;
        }

        public String toTypeName() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.name.length() && Character.isJavaIdentifierPart(this.name.charAt(i))) {
                sb.append(this.name.charAt(i++));
            }
            return sb.toString();
        }

        public int dims() {
            int i = 0;
            int dims = 0;
            while (i < this.name.length()) {
                if (this.name.charAt(i++) != ']') continue;
                ++dims;
            }
            return dims;
        }
    }
}

