/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;

public class ArrayUtils {
    public static Object[] remove(Object[] arr, int i) {
        Assert.isNotNull(arr);
        Assert.isTrue(arr.length > i);
        ArrayList<Object> l = new ArrayList<Object>();
        int j = 0;
        while (j < arr.length) {
            if (j != i) {
                l.add(arr[j]);
            }
            ++j;
        }
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length - 1);
        return l.toArray(newArr);
    }

    public static Object[] add(Object[] arr, Object val) {
        return ArrayUtils.add(arr, arr.length, val);
    }

    public static Object[] add(Object[] arr, int index, Object val) {
        Assert.isNotNull(arr);
        Assert.isTrue(index >= 0 && index <= arr.length);
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length + 1);
        System.arraycopy(arr, 0, newArr, 0, index);
        newArr[index] = val;
        if (arr.length > index) {
            System.arraycopy(arr, index, newArr, index + 1, arr.length - index);
        }
        return newArr;
    }

    public static Object[] removeElement(Object[] arr, Object toRemove) {
        Assert.isNotNull(arr);
        int index = -1;
        int i = 0;
        while (i < arr.length) {
            if (arr[i].equals(toRemove)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length - 1);
            if (index > 0) {
                System.arraycopy(arr, 0, newArr, 0, index);
            }
            System.arraycopy(arr, index + 1, newArr, index, arr.length - index - 1);
            return newArr;
        }
        Object[] newArr = (Object[])Array.newInstance(arr.getClass().getComponentType(), arr.length);
        System.arraycopy(arr, 0, newArr, 0, arr.length);
        return newArr;
    }
}

