/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.model;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.builder.GroovyClasspathContainer;
import org.codehaus.groovy.eclipse.core.util.ArrayUtils;
import org.codehaus.groovy.eclipse.core.util.ObjectUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathEntry;

public class GroovyRuntime {
    public static IPath DSLD_CONTAINER_ID = new Path("GROOVY_DSL_SUPPORT");

    public static void removeGroovyNature(IProject project) throws CoreException {
        GroovyCore.trace("GroovyRuntime.removeGroovyNature()");
        IProjectDescription description = project.getDescription();
        Object[] ids = description.getNatureIds();
        int i = 0;
        while (i < ids.length) {
            if (ids[i].equals("org.eclipse.jdt.groovy.core.groovyNature")) {
                String[] newIds = (String[])ArrayUtils.remove(ids, i);
                description.setNatureIds(newIds);
                project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public static void removeLibraryFromClasspath(IJavaProject javaProject, IPath libraryPath) throws JavaModelException {
        Object[] oldEntries = javaProject.getRawClasspath();
        int i = 0;
        while (i < oldEntries.length) {
            IClasspathEntry entry = oldEntries[i];
            if (entry.getPath().equals(libraryPath)) {
                IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.remove(oldEntries, i);
                javaProject.setRawClasspath(newEntries, null);
                return;
            }
            ++i;
        }
    }

    public static void addGroovyRuntime(IProject project) {
        GroovyCore.trace("GroovyRuntime.addGroovyRuntime()");
        try {
            if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
                return;
            }
            if (project.hasNature("org.eclipse.jdt.groovy.core.groovyNature")) {
                return;
            }
            GroovyRuntime.addGroovyNature(project);
            IJavaProject javaProject = JavaCore.create(project);
            GroovyRuntime.addGroovyClasspathContainer(javaProject);
            GroovyRuntime.addLibraryToClasspath(javaProject, DSLD_CONTAINER_ID, true);
        }
        catch (Exception e) {
            GroovyCore.logException("Failed to add groovy runtime support", e);
        }
    }

    public static boolean hasGroovyClasspathContainer(IJavaProject javaProject) throws CoreException {
        return GroovyRuntime.hasClasspathContainer(javaProject, GroovyClasspathContainer.CONTAINER_ID);
    }

    public static IClasspathEntry getGroovyClasspathEntry(IJavaProject javaProject) throws JavaModelException {
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return null;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 5 && (ObjectUtils.equals(entry.getPath(), GroovyClasspathContainer.CONTAINER_ID) || GroovyClasspathContainer.CONTAINER_ID.isPrefixOf(entry.getPath()))) {
                return entry;
            }
            ++i;
        }
        return null;
    }

    public static boolean hasClasspathContainer(IJavaProject javaProject, IPath libraryPath) throws CoreException {
        if (javaProject == null || !javaProject.getProject().isAccessible()) {
            return false;
        }
        IClasspathEntry[] entries = javaProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 5 && (ObjectUtils.equals(entry.getPath(), libraryPath) || libraryPath.isPrefixOf(entry.getPath()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void internalAddGroovyClasspathContainer(IJavaProject javaProject, boolean isMinimal) {
        try {
            if (javaProject == null) {
                return;
            }
            if (GroovyRuntime.hasGroovyClasspathContainer(javaProject)) {
                GroovyRuntime.removeGroovyClasspathContainer(javaProject);
            }
            IClasspathEntry containerEntry = GroovyRuntime.createContainerEntry(isMinimal);
            GroovyRuntime.addClassPathEntry(javaProject, containerEntry);
        }
        catch (CoreException ce) {
            GroovyCore.logException("Failed to add groovy classpath container:" + ce.getMessage(), ce);
            throw new RuntimeException(ce);
        }
    }

    private static IClasspathEntry createContainerEntry(boolean isMinimal) {
        return JavaCore.newContainerEntry(GroovyClasspathContainer.CONTAINER_ID, new IAccessRule[]{}, isMinimal ? GroovyClasspathContainer.MINIMAL_ATTRIBUTE_ARR : new IClasspathAttribute[]{}, true);
    }

    public static void addMinimalGroovyClasspathContainer(IJavaProject javaProject) {
        GroovyRuntime.internalAddGroovyClasspathContainer(javaProject, true);
    }

    public static void addGroovyClasspathContainer(IJavaProject javaProject) {
        GroovyRuntime.internalAddGroovyClasspathContainer(javaProject, false);
    }

    public static void ensureGroovyClasspathContainer(IJavaProject javaProject, boolean isMinimal) {
        try {
            if (javaProject == null) {
                return;
            }
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            boolean found = false;
            boolean workDone = false;
            int i = 0;
            while (i < rawClasspath.length) {
                if (rawClasspath[i].getPath().equals(GroovyClasspathContainer.CONTAINER_ID)) {
                    found = true;
                    if (isMinimal) {
                        if (GroovyClasspathContainer.hasMinimalAttribute(rawClasspath[i])) break;
                        rawClasspath[i] = GroovyRuntime.createContainerEntry(true);
                        workDone = true;
                        break;
                    }
                    if (!GroovyClasspathContainer.hasMinimalAttribute(rawClasspath[i])) break;
                    rawClasspath[i] = GroovyRuntime.createContainerEntry(false);
                    workDone = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                IClasspathEntry[] newClasspath = new IClasspathEntry[rawClasspath.length + 1];
                System.arraycopy(rawClasspath, 0, newClasspath, 0, rawClasspath.length);
                newClasspath[rawClasspath.length] = GroovyRuntime.createContainerEntry(isMinimal);
                workDone = true;
            }
            if (workDone) {
                javaProject.setRawClasspath(rawClasspath, null);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Problem setting groovy classpath container", e);
        }
    }

    public static void removeGroovyClasspathContainer(IJavaProject javaProject) {
        GroovyRuntime.removeClasspathContainer(GroovyClasspathContainer.CONTAINER_ID, javaProject);
    }

    public static void removeClasspathContainer(IPath containerPath, IJavaProject javaProject) {
        try {
            if (!GroovyRuntime.hasGroovyClasspathContainer(javaProject)) {
                return;
            }
            Object[] entries = javaProject.getRawClasspath();
            int removeIndex = -1;
            int i = 0;
            while (i < entries.length) {
                if (entries[i].getPath().equals(containerPath)) {
                    removeIndex = i;
                    break;
                }
                ++i;
            }
            IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.remove(entries, removeIndex);
            javaProject.setRawClasspath(newEntries, null);
        }
        catch (CoreException ce) {
            GroovyCore.logException("Failed to add groovy classpath container:" + ce.getMessage(), ce);
            throw new RuntimeException(ce);
        }
    }

    public static void addLibraryToClasspath(IJavaProject javaProject, IPath libraryPath, boolean isExported) throws JavaModelException {
        boolean alreadyExists = GroovyRuntime.includesClasspathEntry(javaProject, libraryPath.lastSegment());
        if (alreadyExists) {
            return;
        }
        GroovyRuntime.addClassPathEntry(javaProject, new ClasspathEntry(2, 5, libraryPath, ClasspathEntry.INCLUDE_ALL, ClasspathEntry.EXCLUDE_NONE, null, null, null, true, ClasspathEntry.NO_ACCESS_RULES, false, ClasspathEntry.NO_EXTRA_ATTRIBUTES));
    }

    public static void addGroovyNature(IProject project) throws CoreException {
        GroovyCore.trace("GroovyRuntime.addGroovyNature()");
        IProjectDescription description = project.getDescription();
        String[] ids = description.getNatureIds();
        String[] newIds = new String[ids == null ? 1 : ids.length + 1];
        newIds[0] = "org.eclipse.jdt.groovy.core.groovyNature";
        if (ids != null) {
            int i = 1;
            while (i < newIds.length) {
                newIds[i] = ids[i - 1];
                ++i;
            }
        }
        description.setNatureIds(newIds);
        project.setDescription(description, null);
    }

    public static void addClassPathEntry(IJavaProject project, IClasspathEntry newEntry) throws JavaModelException {
        IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.add(project.getRawClasspath(), newEntry);
        project.setRawClasspath(newEntries, null);
    }

    public static void addClassPathEntryToFront(IJavaProject project, IClasspathEntry newEntry) throws JavaModelException {
        IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.add(project.getRawClasspath(), 0, newEntry);
        project.setRawClasspath(newEntries, null);
    }

    public static void removeClassPathEntry(IJavaProject project, IClasspathEntry newEntry) throws JavaModelException {
        IClasspathEntry[] newEntries = (IClasspathEntry[])ArrayUtils.removeElement(project.getRawClasspath(), newEntry);
        project.setRawClasspath(newEntries, null);
    }

    private static boolean includesClasspathEntry(IJavaProject project, String entryName) throws JavaModelException {
        IClasspathEntry[] entries = project.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry entry = entries[i];
            if (entry.getPath().lastSegment().equals(entryName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

