/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.model;

import java.util.LinkedList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.core.util.ReflectionUtils;
import org.eclipse.jdt.internal.core.SourceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyProjectFacade {
    private IJavaProject project;

    public static boolean isGroovyProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.jdt.groovy.core.groovyNature");
        }
        catch (CoreException e) {
            GroovyCore.logException("Error getting project nature: " + proj.getName(), e);
            return false;
        }
    }

    public GroovyProjectFacade(IJavaProject project) {
        this.project = project;
    }

    public GroovyProjectFacade(IJavaElement elt) {
        this.project = elt.getJavaProject();
    }

    public IJavaElement groovyNodeToJavaElement(ASTNode node, IFile file) {
        ICompilationUnit unit = JavaCore.createCompilationUnitFrom(file);
        if (!(unit instanceof GroovyCompilationUnit)) {
            GroovyCore.logWarning("Trying to get a groovy element from a non-groovy file: " + file.getName());
            return unit;
        }
        try {
            int start = node.getStart();
            IJavaElement elt = unit.getElementAt(start);
            if (node instanceof DeclarationExpression) {
                node.getEnd();
                return ReflectionUtils.createLocalVariable(elt, ((DeclarationExpression)node).getVariableExpression().getName(), start, Signature.createTypeSignature(((DeclarationExpression)node).getVariableExpression().getType().getName(), false));
            }
            return elt;
        }
        catch (Exception e) {
            GroovyCore.logException("Error converting from Groovy Element to Java Element: " + node.getText(), e);
            return null;
        }
    }

    public IType groovyClassToJavaType(ClassNode node) {
        ClassNode toLookFor;
        block6: {
            try {
                toLookFor = node;
                if (node.getEnclosingMethod() == null) break block6;
                toLookFor = node.getEnclosingMethod().getDeclaringClass();
                IType enclosing = this.groovyClassToJavaType(node.getEnclosingMethod().getDeclaringClass());
                if (enclosing != null) {
                    if (!enclosing.isBinary()) {
                        return this.findAnonymousInnerClass(enclosing, (InnerClassNode)node);
                    }
                    return this.project.findType(node.getName(), new NullProgressMonitor());
                }
                return null;
            }
            catch (JavaModelException e) {
                GroovyCore.logException("Error converting from Groovy Element to Java Element: " + node.getName(), e);
                return null;
            }
        }
        String name = toLookFor.getName().replace('$', '.');
        IType type = this.project.findType(name, new NullProgressMonitor());
        if (type != null && toLookFor != node && !(type = type.getType("", 1)).exists()) {
            type = null;
        }
        return type;
    }

    private IType findAnonymousInnerClass(IType enclosing, InnerClassNode anon) throws JavaModelException {
        IMethod[] children = enclosing.getMethods();
        MethodNode enclosingMethod = anon.getEnclosingMethod();
        if (enclosingMethod == null) {
            return null;
        }
        Parameter[] parameters = enclosingMethod.getParameters();
        if (parameters == null) {
            parameters = new Parameter[]{};
        }
        IMethod[] iMethodArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            IMethod child = iMethodArray[n2];
            if (child.getElementName().equals(enclosingMethod.getName()) && (names = child.getParameterNames()).length == parameters.length) {
                int i = 0;
                while (i < names.length) {
                    if (!names[i].equals(parameters[i].getName())) {
                        // empty if block
                    }
                    ++i;
                }
                IType found = child.getType("", 1);
                if (found.exists()) {
                    return found;
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    GroovyCompilationUnit groovyModuleToCompilationUnit(ModuleNode node) {
        IType type;
        ClassNode classNode;
        List<ClassNode> classes = node.getClasses();
        ClassNode classNode2 = classNode = classes.size() > 0 ? classes.get(0) : null;
        if (classNode != null && (type = this.groovyClassToJavaType(classNode)) instanceof SourceType) {
            return (GroovyCompilationUnit)type.getCompilationUnit();
        }
        GroovyCore.logWarning("Trying to get GroovyCompilationUnit for non-groovy module: " + node.getDescription());
        return null;
    }

    public ClassNode getClassNodeForName(String name) {
        try {
            IType type = this.project.findType(name, new NullProgressMonitor());
            if (type instanceof SourceType) {
                return this.javaTypeToGroovyClass(type);
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException(e.getMessage(), e);
        }
        return null;
    }

    private ClassNode javaTypeToGroovyClass(IType type) {
        ICompilationUnit unit = type.getCompilationUnit();
        if (unit instanceof GroovyCompilationUnit) {
            ModuleNode module = ((GroovyCompilationUnit)unit).getModuleNode();
            List<ClassNode> classes = module.getClasses();
            for (ClassNode classNode : classes) {
                if (!classNode.getNameWithoutPackage().equals(type.getElementName())) continue;
                return classNode;
            }
        }
        return null;
    }

    public List<IType> findAllRunnableTypes() throws JavaModelException {
        IPackageFragmentRoot[] roots;
        List<IType> results = ListUtil.newList(new IType[0]);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.project.getAllPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isReadOnly()) {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement child = iJavaElementArray[n4];
                    if (child.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)child).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            results.addAll(GroovyProjectFacade.findAllRunnableTypes(unit));
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    public static List<IType> findAllRunnableTypes(ICompilationUnit unit) throws JavaModelException {
        IType[] types;
        LinkedList<IType> results = new LinkedList<IType>();
        IType[] iTypeArray = types = unit.getAllTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            if (GroovyProjectFacade.hasRunnableMain(type)) {
                results.add(type);
            }
            ++n2;
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasRunnableMain(IType type) {
        try {
            IMethod[] allMethods;
            IMethod[] iMethodArray = allMethods = type.getMethods();
            int n = allMethods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals("main") && Flags.isStatic(method.getFlags()) && (method.getReturnType().equals("V") || method.getReturnType().endsWith("java.lang.Object;")) && GroovyProjectFacade.hasAppropriateArrayArgsForMain(method.getParameterTypes())) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            GroovyCore.logException("Exception searching for main method in " + type, e);
        }
        return false;
    }

    private static boolean hasAppropriateArrayArgsForMain(String[] params) {
        String typeName;
        if (params == null || params.length != 1) {
            return false;
        }
        int array = Signature.getArrayCount(params[0]);
        if (array == 1) {
            typeName = "String";
        } else if (array == 0) {
            typeName = "Object";
        } else {
            return false;
        }
        String sigNoArray = Signature.getElementType(params[0]);
        String name = Signature.getSignatureSimpleName(sigNoArray);
        String qual = Signature.getSignatureQualifier(sigNoArray);
        return name.equals(typeName) && (qual == null || qual.equals("java.lang") || qual.equals(""));
    }

    public IJavaProject getProject() {
        return this.project;
    }

    public boolean isGroovyScript(IType type) {
        ClassNode node = this.javaTypeToGroovyClass(type);
        if (node != null) {
            return node.isScript();
        }
        return false;
    }

    public List<IType> findAllScripts() throws JavaModelException {
        IPackageFragmentRoot[] roots;
        List<IType> results = ListUtil.newList(new IType[0]);
        IPackageFragmentRoot[] iPackageFragmentRootArray = roots = this.project.getAllPackageFragmentRoots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
            if (!root.isReadOnly()) {
                IJavaElement[] children;
                IJavaElement[] iJavaElementArray = children = root.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElement child = iJavaElementArray[n4];
                    if (child.getElementType() == 4) {
                        ICompilationUnit[] units;
                        ICompilationUnit[] iCompilationUnitArray = units = ((IPackageFragment)child).getCompilationUnits();
                        int n5 = units.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            ICompilationUnit unit = iCompilationUnitArray[n6];
                            if (unit instanceof GroovyCompilationUnit) {
                                IType[] iTypeArray = unit.getTypes();
                                int n7 = iTypeArray.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    IType type = iTypeArray[n8];
                                    if (this.isGroovyScript(type)) {
                                        results.add(type);
                                    }
                                    ++n8;
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return results;
    }

    public boolean isGroovyScript(ICompilationUnit unit) {
        GroovyCompilationUnit gunit;
        ModuleNode module;
        if (unit instanceof GroovyCompilationUnit && (module = (gunit = (GroovyCompilationUnit)unit).getModuleNode()) != null) {
            for (ClassNode clazz : module.getClasses()) {
                if (!clazz.isScript()) continue;
                return true;
            }
        }
        return false;
    }
}

