/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ListUtil;

public class StringSourceBuffer
implements ISourceBuffer {
    private final char[] sourceCode;
    private final List lineOffsets;

    public StringSourceBuffer(String sourceCode) {
        this.sourceCode = new char[sourceCode.length()];
        sourceCode.getChars(0, sourceCode.length(), this.sourceCode, 0);
        this.lineOffsets = this.createLineLookup(this.sourceCode);
    }

    private List createLineLookup(char[] sourceCode) {
        if (sourceCode.length == 0) {
            return new ArrayList();
        }
        List<Integer> offsets = ListUtil.newList(new Integer[0]);
        offsets.add(new Integer(0));
        int i = 0;
        while (i < sourceCode.length) {
            char ch = sourceCode[i];
            if (ch == '\r') {
                if (i + 1 < sourceCode.length) {
                    ch = sourceCode[i + 1];
                    if (ch == '\n') {
                        offsets.add(new Integer(++i + 1));
                    } else {
                        offsets.add(new Integer(i + 1));
                    }
                } else {
                    offsets.add(new Integer(i + 1));
                }
            } else if (ch == '\n') {
                offsets.add(new Integer(i + 1));
            }
            ++i;
        }
        return offsets;
    }

    public char charAt(int offset) {
        try {
            return this.sourceCode[offset];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Offset: " + offset + ", Range: [0.." + (this.sourceCode.length - 1) + "]");
        }
    }

    public int length() {
        return this.sourceCode.length;
    }

    public CharSequence subSequence(int start, int end) {
        return new String(this.sourceCode, start, end - start);
    }

    public int[] toLineColumn(int offset) {
        try {
            int lineOffset;
            int i = 0;
            while (i < this.lineOffsets.size()) {
                lineOffset = (Integer)this.lineOffsets.get(i);
                if (offset < lineOffset) {
                    lineOffset = (Integer)this.lineOffsets.get(i - 1);
                    return new int[]{i, offset - lineOffset + 1};
                }
                ++i;
            }
            int line = this.lineOffsets.size();
            lineOffset = (Integer)this.lineOffsets.get(line - 1);
            return new int[]{line, offset - lineOffset + 1};
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IndexOutOfBoundsException("Offset: " + offset + ", Range: [0.." + (this.sourceCode.length - 1) + "]");
        }
    }

    public int toOffset(int line, int column) {
        int offset = (Integer)this.lineOffsets.get(line - 1);
        return offset + column - 1;
    }
}

