/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.builder;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.GroovyCoreActivator;
import org.codehaus.groovy.eclipse.core.compiler.CompilerUtils;
import org.codehaus.groovy.eclipse.core.model.GroovyRuntime;
import org.codehaus.groovy.eclipse.core.util.ListUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.ClasspathAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyClasspathContainer
implements IClasspathContainer {
    public static final Path CONTAINER_ID = new Path("GROOVY_SUPPORT");
    public static final IClasspathAttribute MINIMAL_ATTRIBUTE = new ClasspathAttribute("minimal", "true");
    public static final String DESC = "Groovy Libraries";
    public static final IClasspathAttribute[] MINIMAL_ATTRIBUTE_ARR = new IClasspathAttribute[]{MINIMAL_ATTRIBUTE};
    private IClasspathEntry[] entries;
    private IProject project;

    public GroovyClasspathContainer(IProject project) {
        this.project = project;
    }

    @Override
    public synchronized IClasspathEntry[] getClasspathEntries() {
        if (this.entries == null) {
            this.updateEntries();
        }
        return this.entries;
    }

    synchronized void reset() {
        this.entries = null;
    }

    private void updateEntries() {
        List<IClasspathEntry> newEntries = ListUtil.newList(new IClasspathEntry[0]);
        try {
            IClasspathAttribute[] attrs;
            URL groovyURL = CompilerUtils.getExportedGroovyAllJar();
            Path runtimeJarPath = new Path(groovyURL.getPath());
            File srcJarFile = new File(groovyURL.getPath().replace(".jar", "-sources.jar"));
            Path srcJarPath = srcJarFile.exists() ? new Path(srcJarFile.getAbsolutePath()) : null;
            File javadocJarFile = new File(groovyURL.getPath().replace(".jar", "-javadoc.jar"));
            if (javadocJarFile.exists()) {
                String javadocJarPath = javadocJarFile.getAbsolutePath();
                ClasspathAttribute cpattr = new ClasspathAttribute("javadoc_location", javadocJarPath);
                attrs = new IClasspathAttribute[]{cpattr};
            } else {
                attrs = new IClasspathAttribute[]{};
            }
            IClasspathEntry entry = JavaCore.newLibraryEntry(runtimeJarPath, srcJarPath, null, null, attrs, true);
            newEntries.add(entry);
            if (!GroovyClasspathContainer.hasMinimalAttribute(GroovyRuntime.getGroovyClasspathEntry(JavaCore.create(this.project)))) {
                URL[] extraJars;
                URL[] uRLArray = extraJars = CompilerUtils.getExtraJarsForClasspath();
                int n = extraJars.length;
                int n2 = 0;
                while (n2 < n) {
                    URL jar = uRLArray[n2];
                    Path jarPath = new Path(jar.getPath());
                    newEntries.add(JavaCore.newLibraryEntry(jarPath, null, null));
                    ++n2;
                }
                if (this.useGroovyLibs()) {
                    newEntries.addAll(this.getGroovyJarsInDotGroovyLib());
                }
            }
            this.entries = newEntries.toArray(new IClasspathEntry[0]);
        }
        catch (Exception e) {
            GroovyCore.logException("Problem finding groovy runtime", e);
            this.entries = new IClasspathEntry[0];
        }
    }

    public static boolean hasMinimalAttribute(IClasspathEntry entry) throws JavaModelException {
        IClasspathAttribute[] extraAttributes;
        if (entry == null) {
            return false;
        }
        IClasspathAttribute[] iClasspathAttributeArray = extraAttributes = entry.getExtraAttributes();
        int n = extraAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if (attribute.getName().equals(MINIMAL_ATTRIBUTE.getName()) && Boolean.valueOf(attribute.getValue()).booleanValue()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean useGroovyLibs() {
        ProjectScope projectScope = new ProjectScope(this.project);
        IEclipsePreferences projectNode = projectScope.getNode("org.codehaus.groovy.eclipse.core");
        String val = projectNode.get("groovy.classpath.use.groovy,lib", "default");
        if (val.equals(Boolean.TRUE.toString())) {
            return true;
        }
        if (val.equals(Boolean.FALSE.toString())) {
            return false;
        }
        return GroovyCoreActivator.getDefault().getPreference("groovy.classpath.use.groovy.lib.global", true);
    }

    private Collection<IClasspathEntry> getGroovyJarsInDotGroovyLib() {
        File[] files = CompilerUtils.findJarsInDotGroovyLocation();
        ArrayList<IClasspathEntry> newEntries = new ArrayList<IClasspathEntry>(files.length);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            IClasspathEntry entry = JavaCore.newLibraryEntry(new Path(file.getAbsolutePath()), null, null, null, new IClasspathAttribute[0], true);
            newEntries.add(entry);
            ++n2;
        }
        return newEntries;
    }

    @Override
    public String getDescription() {
        return DESC;
    }

    @Override
    public int getKind() {
        return 1;
    }

    @Override
    public IPath getPath() {
        return CONTAINER_ID;
    }
}

