/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.vmplugin.v8;

import groovy.lang.Closure;
import groovy.transform.stc.ClosureParams;
import groovy.transform.stc.FirstParam;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class PluginDefaultGroovyMethods {
    private PluginDefaultGroovyMethods() {
    }

    public static boolean asBoolean(Optional<?> optional) {
        return optional.isPresent();
    }

    public static <S, T> Optional<T> collect(Optional<S> self, @ClosureParams(value=FirstParam.FirstGenericType.class) Closure<T> transform) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(transform);
        if (!self.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(transform.call((Object)self.get()));
    }

    public static <S, T> Future<T> collect(Future<S> self, @ClosureParams(value=FirstParam.FirstGenericType.class) Closure<T> transform) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(transform);
        return new TransformedFuture(self, transform);
    }

    public static <T> List<T> toList(Stream<T> stream) {
        return stream.collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(Stream<T> stream) {
        return stream.collect(Collectors.toSet());
    }

    public static <T> List<T> toList(BaseStream<T, ? extends BaseStream> stream) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(stream.iterator(), 16), false).collect(Collectors.toList());
    }

    public static <T> Set<T> toSet(BaseStream<T, ? extends BaseStream> stream) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(stream.iterator(), 16), false).collect(Collectors.toSet());
    }

    public static <T> Stream<T> stream(T[] self) {
        return Arrays.stream(self);
    }

    public static Stream<Integer> stream(int[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Long> stream(long[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Double> stream(double[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Character> stream(char[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> Character.valueOf(self[i]));
    }

    public static Stream<Byte> stream(byte[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Short> stream(short[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Boolean> stream(boolean[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> self[i]);
    }

    public static Stream<Float> stream(float[] self) {
        return IntStream.range(0, self.length).mapToObj(i -> Float.valueOf(self[i]));
    }

    private static class TransformedFuture<E>
    implements Future<E> {
        private Future delegate;
        private Closure<E> transform;

        private TransformedFuture(Future delegate, Closure<E> transform) {
            this.delegate = delegate;
            this.transform = transform;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public E get() throws InterruptedException, ExecutionException {
            return this.transform.call(this.delegate.get());
        }

        @Override
        public E get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.transform.call(this.delegate.get(timeout, unit));
        }
    }
}

