/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.refactoring.formatter.GroovyFormatter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class WhitespaceRemover
extends GroovyFormatter {
    private static final Pattern TRAILING_WHITESPACE_PATTERN = Pattern.compile("\\s+$");
    private final MultiTextEdit edits;

    public WhitespaceRemover(ITextSelection sel, IDocument doc) {
        this(sel, doc, new MultiTextEdit());
    }

    public WhitespaceRemover(ITextSelection sel, IDocument doc, MultiTextEdit edits) {
        super(sel, doc);
        this.edits = edits;
    }

    @Override
    public TextEdit format() {
        try {
            int i = 0;
            while (i < this.document.getNumberOfLines()) {
                IRegion lineInfo = this.document.getLineInformation(i);
                String line = this.document.get(lineInfo.getOffset(), lineInfo.getLength());
                Matcher matcher = TRAILING_WHITESPACE_PATTERN.matcher(line);
                if (matcher.find()) {
                    int whitespaceOffset = lineInfo.getOffset() + matcher.start();
                    int whitespaceLength = matcher.end() - matcher.start();
                    this.addWhitespaceRemoval(whitespaceOffset, whitespaceLength);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            GroovyCore.logException("Cannot perform whitespace removal.", e);
        }
        return this.edits;
    }

    private void addWhitespaceRemoval(int whitespaceOffset, int whitespaceLength) {
        DeleteEdit deleteWhitespace = new DeleteEdit(whitespaceOffset, whitespaceLength);
        try {
            this.edits.addChild((TextEdit)deleteWhitespace);
        }
        catch (MalformedTreeException e) {
            GroovyCore.logWarning("Ignoring conflicting edit: " + deleteWhitespace, e);
        }
    }
}

