/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.formatter;

import groovyjarjarantlr.Token;
import java.util.List;
import org.codehaus.groovy.eclipse.refactoring.formatter.DefaultGroovyFormatter;
import org.codehaus.groovy.eclipse.refactoring.formatter.IFormatterPreferences;
import org.codehaus.groovy.eclipse.refactoring.formatter.LineIndentations;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class GroovyLineWrapper {
    private final DefaultGroovyFormatter formatter;
    private final IFormatterPreferences preferences;
    private final LineIndentations lineIndentations;

    public GroovyLineWrapper(DefaultGroovyFormatter formatter, IFormatterPreferences preferences, LineIndentations lineIndentations) {
        this.formatter = formatter;
        this.preferences = preferences;
        this.lineIndentations = lineIndentations;
    }

    public TextEdit getLineWrapEdits() throws BadLocationException {
        MultiTextEdit lineWraps = new MultiTextEdit();
        int maxLineLength = this.preferences.getMaxLineLength();
        for (List<Token> tokenLine : this.formatter.getLineTokens()) {
            int lastToken;
            Token lastTokenOnLine = tokenLine.get(tokenLine.size() - 1);
            if (lastTokenOnLine.getColumn() < maxLineLength) continue;
            int offsetInLine = 0;
            while ((lastToken = this.getLastTokenPositionUnderMaximum(tokenLine, offsetInLine)) > 0 && lastToken != tokenLine.size() - 2) {
                int replOffset = this.formatter.getOffsetOfTokenEnd(tokenLine.get(lastToken));
                int replLength = this.formatter.getOffsetOfToken(tokenLine.get(lastToken + 1)) - replOffset;
                String insert = this.formatter.getNewLine();
                int indentationLevel = this.lineIndentations.getLineIndentation(lastTokenOnLine.getLine());
                if (!this.lineIndentations.isMultilineIndentation(lastTokenOnLine.getLine())) {
                    indentationLevel += this.preferences.getIndentationMultiline();
                }
                String leadingGap = this.formatter.getLeadingGap(indentationLevel);
                if (replOffset >= this.formatter.formatOffset && replOffset + replLength <= this.formatter.formatOffset + this.formatter.formatLength) {
                    lineWraps.addChild((TextEdit)new ReplaceEdit(replOffset, replLength, String.valueOf(insert) + leadingGap));
                }
                offsetInLine = tokenLine.get(lastToken + 1).getColumn() - leadingGap.length();
            }
        }
        return lineWraps;
    }

    private int getLastTokenPositionUnderMaximum(List<Token> tokens, int offsetInLine) throws BadLocationException {
        int i = tokens.size() - 2;
        while (i >= 0) {
            Token token = tokens.get(i);
            if (token.getColumn() - offsetInLine + this.formatter.getTokenLength(token) <= this.preferences.getMaxLineLength()) {
                return i;
            }
            --i;
        }
        return 0;
    }
}

