/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.convert;

import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class ConvertToClosureRefactoring {
    private final IMethod targetMethod;

    public ConvertToClosureRefactoring(GroovyCompilationUnit unit, int offset) {
        this.targetMethod = this.findMethod(unit, offset);
    }

    private IMethod findMethod(GroovyCompilationUnit unit, int offset) {
        if (unit.exists() && unit.isOnBuildPath()) {
            IJavaElement maybeMethod;
            block6: {
                maybeMethod = unit.getElementAt(offset);
                if (maybeMethod instanceof IMethod) break block6;
                return null;
            }
            try {
                ISourceRange nameRange = ((IMethod)maybeMethod).getNameRange();
                if (nameRange.getLength() == maybeMethod.getElementName().length()) {
                    return (IMethod)maybeMethod;
                }
                char[] contents = unit.getContents();
                if (contents.length > nameRange.getOffset() && (contents[nameRange.getOffset()] == '\"' || contents[nameRange.getOffset()] == '\'')) {
                    return (IMethod)maybeMethod;
                }
            }
            catch (JavaModelException e) {
                GroovyCore.logException("Error finding enclosing method for refactoring", (Throwable)((Object)e));
            }
        }
        return null;
    }

    public void applyRefactoring(IDocument document) {
        if (this.targetMethod != null) {
            try {
                TextEdit thisEdit = this.createEdit(document);
                if (thisEdit != null) {
                    thisEdit.apply(document);
                }
            }
            catch (Exception e) {
                GroovyCore.logException("Oops.", e);
            }
        }
    }

    public boolean isApplicable() {
        return this.targetMethod != null && this.targetMethod.exists();
    }

    public TextEdit createEdit(IDocument doc) throws BadLocationException, JavaModelException {
        ISourceRange nameRange = this.targetMethod.getSourceRange();
        int openingParen = this.findOpenParen(doc, this.targetMethod, nameRange);
        int closingParen = this.findCloseParen(doc, openingParen);
        int openingBracket = this.findOpenBracket(doc, closingParen);
        if (openingParen >= doc.getLength() || doc.getChar(openingParen) != '(') {
            return null;
        }
        if (closingParen >= doc.getLength() || doc.getChar(closingParen) != ')') {
            return null;
        }
        if (openingBracket >= doc.getLength() || doc.getChar(openingBracket) != '{') {
            return null;
        }
        MultiTextEdit edit = new MultiTextEdit();
        if (this.targetMethod.getParameterTypes().length > 0) {
            edit.addChild((TextEdit)new ReplaceEdit(openingParen, 1, " = { "));
            edit.addChild((TextEdit)new ReplaceEdit(closingParen, openingBracket - closingParen + 1, " ->"));
        } else {
            edit.addChild((TextEdit)new ReplaceEdit(openingParen, 1, " = {"));
            edit.addChild((TextEdit)new DeleteEdit(closingParen, openingBracket - closingParen + 1));
        }
        return edit;
    }

    private int findOpenParen(IDocument doc, IMethod targetMethod, ISourceRange nameRange) throws BadLocationException {
        int offset = nameRange.getOffset() + targetMethod.getElementName().length();
        while (offset < doc.getLength() && doc.getChar(offset) != '(') {
            ++offset;
        }
        return offset;
    }

    private int findOpenBracket(IDocument doc, int closingParen) throws BadLocationException {
        int offset = closingParen;
        while (offset < doc.getLength() && doc.getChar(offset) != '{') {
            ++offset;
        }
        return offset;
    }

    private int findCloseParen(IDocument doc, int open) throws BadLocationException {
        int offset = open;
        while (offset < doc.getLength() && doc.getChar(offset) != ')') {
            ++offset;
        }
        return offset;
    }
}

