/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.refactoring.core.convert;

import java.util.List;
import java.util.Set;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.eclipse.codebrowsing.requestor.Region;
import org.codehaus.groovy.eclipse.core.GroovyCore;
import org.codehaus.groovy.eclipse.core.util.VisitCompleteException;
import org.codehaus.groovy.eclipse.refactoring.core.utils.ASTTools;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class AssignStatementToNewLocalRefactoring {
    private final GroovyCompilationUnit unit;
    private final int offset;
    private int newLength;
    private int newOffset;
    private Expression expression;
    private boolean atExpressionStatement;

    public AssignStatementToNewLocalRefactoring(GroovyCompilationUnit unit, int offset) {
        this.unit = unit;
        this.offset = offset;
    }

    public void applyRefactoring(IDocument document) {
        if (this.atExpressionStatement) {
            TextEdit thisEdit = this.createEdit(document);
            try {
                if (thisEdit != null) {
                    thisEdit.apply(document);
                }
            }
            catch (Exception e) {
                GroovyCore.logException("Oops.", e);
            }
        }
    }

    public boolean isApplicable() {
        if (this.unit == null) {
            return false;
        }
        return this.atExpressionStatement();
    }

    private boolean atExpressionStatement() {
        this.atExpressionStatement = false;
        ModuleNode moduleNode = this.unit.getModuleNode();
        List<ClassNode> classes = moduleNode.getClasses();
        if (classes.isEmpty()) {
            classes.add(moduleNode.getScriptClassDummy());
        }
        GroovyClassVisitor visitor = this.createClassVisitor();
        for (ClassNode classNode : classes) {
            try {
                visitor.visitClass(classNode);
            }
            catch (VisitCompleteException expected) {
                break;
            }
        }
        return this.atExpressionStatement;
    }

    private GroovyClassVisitor createClassVisitor() {
        final Region region = new Region(this.offset, 0);
        return new ClassCodeVisitorSupport(){

            /*
             * Enabled aggressive block sorting
             */
            private void processExpression(Expression statementExpression) {
                if (!(statementExpression instanceof BinaryExpression)) {
                    AssignStatementToNewLocalRefactoring.this.expression = statementExpression;
                    AssignStatementToNewLocalRefactoring.this.atExpressionStatement = true;
                    return;
                }
                BinaryExpression bexp = (BinaryExpression)statementExpression;
                if (!bexp.getOperation().getText().equals("=")) {
                    AssignStatementToNewLocalRefactoring.this.expression = statementExpression;
                    AssignStatementToNewLocalRefactoring.this.atExpressionStatement = true;
                    return;
                }
                if (!(bexp.getRightExpression() instanceof ClosureExpression)) throw new VisitCompleteException();
            }

            @Override
            public void visitExpressionStatement(ExpressionStatement statement) {
                if (region.regionIsCoveredByNode((ASTNode)statement)) {
                    this.processExpression(statement.getExpression());
                }
                super.visitExpressionStatement(statement);
            }

            @Override
            public void visitReturnStatement(ReturnStatement statement) {
                if (region.regionIsCoveredByNode((ASTNode)statement)) {
                    String source;
                    char[] contents = AssignStatementToNewLocalRefactoring.this.unit.getContents();
                    if (statement.getStart() >= 0 && statement.getStart() + statement.getLength() < contents.length && !(source = String.valueOf(contents, statement.getStart(), statement.getLength())).matches("return\\b.*")) {
                        this.processExpression(statement.getExpression());
                    }
                }
                super.visitReturnStatement(statement);
            }
        };
    }

    public TextEdit createEdit(IDocument doc) {
        MultiTextEdit edit = new MultiTextEdit();
        String candidate = this.expression instanceof ConstantExpression ? ((ConstantExpression)this.expression).getText() : (this.expression instanceof VariableExpression ? ((VariableExpression)this.expression).getName() : (this.expression instanceof ClassExpression ? ((ClassExpression)this.expression).getType().getNameWithoutPackage() : (this.expression instanceof MethodCallExpression ? ((MethodCallExpression)this.expression).getMethodAsString() : (this.expression instanceof StaticMethodCallExpression ? ((StaticMethodCallExpression)this.expression).getMethod() : (this.expression instanceof MapExpression ? "map" : (this.expression instanceof ListExpression ? "list" : "temp"))))));
        Set<Variable> vars = ASTTools.getVariablesInScope(this.unit.getModuleNode(), this.expression);
        String[] variableNames = new String[vars.size()];
        int i = 0;
        for (Variable v : vars) {
            variableNames[i] = v.getName();
            ++i;
        }
        String[] names = NamingConventions.suggestVariableNames(5, 1, candidate, null, 0, variableNames, true);
        edit.addChild((TextEdit)new InsertEdit(this.expression.getStart(), "def " + names[0] + " = "));
        this.newOffset = this.expression.getStart() + "def ".length();
        this.newLength = names[0].length();
        return edit;
    }

    public Point getNewSelection() {
        return new Point(this.newOffset, this.newLength);
    }
}

