/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.core.util;

import org.codehaus.groovy.eclipse.core.ISourceBuffer;
import org.codehaus.groovy.eclipse.core.impl.StringSourceBuffer;
import org.codehaus.groovy.eclipse.core.util.ParseException;
import org.codehaus.groovy.eclipse.core.util.Token;
import org.codehaus.groovy.eclipse.core.util.TokenStream;
import org.codehaus.groovy.eclipse.core.util.TokenStreamException;

public class ExpressionFinder {
    public String findForCompletions(ISourceBuffer sourceBuffer, int offset) throws ParseException {
        TokenStream stream;
        int endOffset;
        Token token;
        block19: {
            block18: {
                block17: {
                    boolean offsetIsWhitespace;
                    block16: {
                        boolean offsetIsQuote;
                        block15: {
                            token = null;
                            endOffset = 0;
                            stream = new TokenStream(sourceBuffer, offset);
                            token = stream.peek();
                            if (token != null && !token.isType(Token.Type.EOF)) break block15;
                            return null;
                        }
                        endOffset = token.endOffset;
                        offsetIsWhitespace = Character.isWhitespace(stream.getCurrentChar());
                        boolean bl = offsetIsQuote = stream.getCurrentChar() == '\"' || stream.getCurrentChar() == '\'';
                        if (!offsetIsQuote) break block16;
                        return null;
                    }
                    this.skipLineBreaksAndComments(stream);
                    token = stream.next();
                    if (!offsetIsWhitespace || token.isDotAccess() || token.isType(Token.Type.DOUBLE_DOT)) break block17;
                    return "";
                }
                if (!"@".equals(token.text)) break block18;
                return "@";
            }
            if (!token.isType(Token.Type.EOF)) break block19;
            return null;
        }
        try {
            switch (token.getType()) {
                case DOT: 
                case DOUBLE_DOT: 
                case SAFE_DEREF: 
                case SPREAD: 
                case FIELD_ACCESS: 
                case METHOD_POINTER: {
                    token = this.dot(stream);
                    break;
                }
                case IDENT: {
                    token = this.ident(stream);
                    break;
                }
                case BRACK_BLOCK: {
                    token = null;
                    break;
                }
                default: {
                    throw new ParseException(token);
                }
            }
        }
        catch (TokenStreamException e) {
            Token last = stream.last();
            if (last != null) {
                token = last;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (token != null) {
            return sourceBuffer.subSequence(token.startOffset, endOffset).toString();
        }
        return "";
    }

    public int findTokenEnd(ISourceBuffer buffer, int initialOffset) {
        int candidate = initialOffset;
        while (buffer.length() > candidate) {
            if (!Character.isJavaIdentifierPart(buffer.charAt(candidate))) break;
            ++candidate;
        }
        return candidate;
    }

    public String[] splitForCompletion(String expression) {
        String[] split = this.splitForCompletionNoTrim(expression);
        if (split[0] != null) {
            split[0] = split[0].trim();
            if (split[0].startsWith("$")) {
                split[0] = split[0].substring(1);
            }
        }
        if (split[1] != null) {
            split[1] = split[1].trim();
            if (split[1].startsWith("$")) {
                split[1] = split[1].substring(1);
            }
        }
        return split;
    }

    public String[] splitForCompletionNoTrim(String expression) {
        String[] stringArray = new String[2];
        stringArray[0] = "";
        String[] ret = stringArray;
        if (expression == null || expression.trim().length() < 1) {
            return ret;
        }
        TokenStream stream = new TokenStream(new StringSourceBuffer(expression), expression.length() - 1);
        try {
            this.skipLineBreaksAndComments(stream);
            Token token0 = stream.next();
            this.skipLineBreaksAndComments(stream);
            Token token1 = stream.next();
            this.skipLineBreaksAndComments(stream);
            Token token2 = stream.next();
            if (token0.isDotAccess() && token1.isValidBeforeDot()) {
                ret[0] = expression.substring(0, token1.endOffset);
                ret[1] = "";
            } else if (token0.isType(Token.Type.IDENT) && token1.isDotAccess() && token2.isValidBeforeDot()) {
                ret[0] = expression.substring(0, token2.endOffset);
                ret[1] = expression.substring(token0.startOffset, expression.length());
            } else if (token0.isType(Token.Type.IDENT)) {
                ret[0] = expression;
            }
        }
        catch (IllegalStateException | TokenStreamException exception) {
            // empty catch block
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     */
    public NameAndLocation findPreviousTypeNameToken(ISourceBuffer buffer, int start) {
        current = Math.min(start, buffer.length()) - 1;
        while (current >= 0 && !Character.isWhitespace(buffer.charAt(current)) && Character.isJavaIdentifierPart(buffer.charAt(current))) {
            --current;
        }
        if (current < 0 || !Character.isWhitespace(buffer.charAt(current))) {
            return null;
        }
        sb = new StringBuilder();
        while (current >= 0 && (Character.isWhitespace(buffer.charAt(current)) || buffer.charAt(current) == '[' || buffer.charAt(current) == ']') && buffer.charAt(current) != '\n' && buffer.charAt(current) != '\r') {
            sb.append(buffer.charAt(current--));
        }
        if (current >= 0 && Character.isJavaIdentifierPart(buffer.charAt(current))) ** GOTO lbl16
        return null;
lbl-1000:
        // 1 sources

        {
            sb.append(buffer.charAt(current--));
lbl16:
            // 2 sources

            ** while (current >= 0 && Character.isJavaIdentifierPart((char)buffer.charAt((int)current)))
        }
lbl17:
        // 1 sources

        if (sb.length() > 0) {
            return new NameAndLocation(sb.reverse().toString(), current + 1);
        }
        return null;
    }

    private void skipLineBreaksAndComments(TokenStream stream) throws TokenStreamException {
        this.skipLineBreaks(stream);
        this.skipLineComments(stream);
    }

    private Token dot(TokenStream stream) throws TokenStreamException, ParseException {
        this.skipLineBreaksAndComments(stream);
        Token token = stream.next();
        switch (token.getType()) {
            case IDENT: {
                return this.ident(stream);
            }
            case QUOTED_STRING: {
                return this.quotedString(stream);
            }
            case PAREN_BLOCK: {
                return this.parenBlock(stream);
            }
            case BRACE_BLOCK: {
                return this.braceBlock(stream);
            }
            case BRACK_BLOCK: {
                return this.brackBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private void skipLineComments(TokenStream stream) throws TokenStreamException {
        while (stream.peek().isType(Token.Type.LINE_COMMENT)) {
            stream.next();
        }
    }

    private void skipLineBreaks(TokenStream stream) throws TokenStreamException {
        while (stream.peek().isType(Token.Type.LINE_BREAK)) {
            stream.next();
        }
    }

    private Token ident(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        Token last = stream.last();
        switch (token.getType()) {
            case LINE_BREAK: {
                this.skipLineBreaksAndComments(stream);
                token = stream.peek();
                if (!token.isDotAccess()) {
                    return new Token(Token.Type.EOF, last.startOffset, last.endOffset, null);
                }
                stream.next();
                return this.dot(stream);
            }
            case DOUBLE_DOT: {
                return new Token(Token.Type.EOF, last.startOffset, last.endOffset, null);
            }
            case DOT: 
            case SAFE_DEREF: 
            case SPREAD: 
            case FIELD_ACCESS: 
            case METHOD_POINTER: {
                stream.next();
                return this.dot(stream);
            }
            case IDENT: {
                if (!token.text.equals("new")) break;
                Token next = stream.next();
                return new Token(Token.Type.EOF, next.startOffset, next.endOffset, null);
            }
        }
        return new Token(Token.Type.EOF, last.startOffset, last.endOffset, null);
    }

    private Token quotedString(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.getType()) {
            case EOF: 
            case LINE_BREAK: {
                Token last = stream.last();
                return new Token(Token.Type.EOF, last.startOffset, last.startOffset, null);
            }
            case SEMI: {
                Token last = stream.last();
                return new Token(Token.Type.EOF, last.startOffset, last.startOffset, null);
            }
            case IDENT: {
                Token last = stream.last();
                return new Token(Token.Type.EOF, last.startOffset, last.startOffset, null);
            }
        }
        throw new ParseException(token);
    }

    private Token parenBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.peek();
        switch (token.getType()) {
            case IDENT: {
                stream.next();
                return this.ident(stream);
            }
            case EOF: 
            case SEMI: 
            case LINE_BREAK: {
                return stream.last();
            }
        }
        throw new ParseException(token);
    }

    private Token braceBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token token = stream.next();
        switch (token.getType()) {
            case IDENT: {
                return this.ident(stream);
            }
            case PAREN_BLOCK: {
                return this.parenBlock(stream);
            }
        }
        throw new ParseException(token);
    }

    private Token brackBlock(TokenStream stream) throws TokenStreamException, ParseException {
        Token last = stream.last();
        Token token = stream.next();
        switch (token.getType()) {
            case EOF: {
                return new Token(Token.Type.EOF, last.startOffset, last.startOffset, null);
            }
            case IDENT: {
                return this.ident(stream);
            }
            case PAREN_BLOCK: {
                return this.parenBlock(stream);
            }
            case BRACE_BLOCK: {
                return this.braceBlock(stream);
            }
            case BRACK_BLOCK: {
                return this.brackBlock(stream);
            }
            case SEMI: 
            case LINE_BREAK: {
                return stream.last();
            }
        }
        throw new ParseException(token);
    }

    public static class NameAndLocation {
        public final String name;
        public final int location;

        public NameAndLocation(String name, int locaiton) {
            this.name = name;
            this.location = locaiton;
        }

        public String toTypeName() {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < this.name.length() && Character.isJavaIdentifierPart(this.name.charAt(i))) {
                sb.append(this.name.charAt(i++));
            }
            return sb.toString();
        }

        public int dims() {
            int i = 0;
            int dims = 0;
            while (i < this.name.length()) {
                if (this.name.charAt(i++) != ']') continue;
                ++dims;
            }
            return dims;
        }
    }
}

