/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame.parser.aapt;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.aapt.Aapt2ErrorNoPathParser;
import com.android.ide.common.blame.parser.aapt.Aapt2ErrorParser;
import com.android.ide.common.blame.parser.aapt.AbstractAaptOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import java.util.List;
import java.util.Map;

public class Aapt2OutputParser
implements PatternAwareOutputParser {
    private final AbstractAaptOutputParser[] parsers;

    public Aapt2OutputParser() {
        this.parsers = new AbstractAaptOutputParser[]{new Aapt2ErrorParser(), new Aapt2ErrorNoPathParser()};
    }

    public Aapt2OutputParser(Map<String, String> identifiedSourceSets) {
        this.parsers = new AbstractAaptOutputParser[]{new Aapt2ErrorParser(identifiedSourceSets), new Aapt2ErrorNoPathParser()};
    }

    @Override
    public boolean parse(String line, OutputLineReader reader, List<Message> messages, ILogger logger) {
        String trimmedLine = line.trim();
        for (AbstractAaptOutputParser parser : this.parsers) {
            try {
                if (!parser.parse(trimmedLine, reader, messages, logger)) continue;
                return true;
            }
            catch (ParsingFailedException parsingFailedException) {
                // empty catch block
            }
        }
        return false;
    }
}

