/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.io;

import com.android.io.CancellableFileIo;
import com.android.repository.io.FileOpUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Stream;

public abstract class FileOp {
    public abstract FileSystem getFileSystem();

    public final void deleteFileOrFolder(File fileOrFolder) {
        if (this.isDirectory(fileOrFolder)) {
            for (File item : this.listFiles(fileOrFolder)) {
                this.deleteFileOrFolder(item);
            }
        }
        this.delete(fileOrFolder);
    }

    public final void setExecutablePermission(File file) throws IOException {
        Path path = this.toPath(file);
        EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
        permissions.add(PosixFilePermission.OWNER_EXECUTE);
        permissions.add(PosixFilePermission.GROUP_EXECUTE);
        permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        Files.setPosixFilePermissions(path, permissions);
    }

    public final void setReadOnly(File file) throws IOException {
        Path path = this.toPath(file);
        if (FileOpUtils.isWindows()) {
            Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]).setReadOnly(true);
        } else {
            EnumSet<PosixFilePermission> permissions = EnumSet.copyOf(Files.getPosixFilePermissions(path, new LinkOption[0]));
            permissions.remove((Object)PosixFilePermission.OWNER_WRITE);
            permissions.remove((Object)PosixFilePermission.GROUP_WRITE);
            permissions.remove((Object)PosixFilePermission.OTHERS_WRITE);
            Files.setPosixFilePermissions(path, permissions);
        }
    }

    public void copyFile(File source, File dest) throws IOException {
        Files.copy(this.toPath(source), this.toPath(dest), new CopyOption[0]);
    }

    public final boolean isSameFile(File file1, File file2) throws IOException {
        return CancellableFileIo.isSameFile((Path)this.toPath(file1), (Path)this.toPath(file2));
    }

    public final boolean exists(File file) {
        return CancellableFileIo.exists((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public final boolean isFile(File file) {
        return CancellableFileIo.isRegularFile((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public final boolean isDirectory(File file) {
        return CancellableFileIo.isDirectory((Path)this.toPath(file), (LinkOption[])new LinkOption[0]);
    }

    public boolean canWrite(File file) {
        return CancellableFileIo.isWritable((Path)this.toPath(file));
    }

    public final long length(File file) throws IOException {
        return CancellableFileIo.size((Path)this.toPath(file));
    }

    public boolean delete(File file) {
        try {
            Files.delete(this.toPath(file));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public final boolean mkdirs(File file) {
        try {
            Files.createDirectories(this.toPath(file), new FileAttribute[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public final File[] listFiles(File file) {
        File[] fileArray;
        block8: {
            Stream children = CancellableFileIo.list((Path)this.toPath(file));
            try {
                fileArray = (File[])children.map(path -> new File(path.toString())).toArray(File[]::new);
                if (children == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (children != null) {
                        try {
                            children.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return new File[0];
                }
            }
            children.close();
        }
        return fileArray;
    }

    public boolean renameTo(File oldFile, File newFile) {
        try {
            Files.move(this.toPath(oldFile), this.toPath(newFile), new CopyOption[0]);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public OutputStream newFileOutputStream(File file) throws IOException {
        return this.newFileOutputStream(file, false);
    }

    public OutputStream newFileOutputStream(File file, boolean append) throws IOException {
        if (append) {
            return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.APPEND);
        }
        return Files.newOutputStream(this.toPath(file), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    public final InputStream newFileInputStream(File file) throws IOException {
        return this.newFileInputStream(this.toPath(file));
    }

    public final InputStream newFileInputStream(Path path) throws IOException {
        return CancellableFileIo.newInputStream((Path)path, (OpenOption[])new OpenOption[0]);
    }

    public final long lastModified(File file) {
        try {
            return CancellableFileIo.getLastModifiedTime((Path)this.toPath(file), (LinkOption[])new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public final boolean createNewFile(File file) throws IOException {
        try {
            Path path = this.toPath(file);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.createFile(path, new FileAttribute[0]);
            return true;
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
    }

    public final boolean canExecute(File file) {
        return CancellableFileIo.isExecutable((Path)this.toPath(file));
    }

    public abstract File ensureRealFile(File var1) throws IOException;

    public final String readText(File f) throws IOException {
        return CancellableFileIo.readString((Path)this.toPath(f));
    }

    public final String[] list(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        String[] names = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            names[i] = contents[i].getName();
        }
        if (filenameFilter == null) {
            return names;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String name : names) {
            if (!filenameFilter.accept(folder, name)) continue;
            result.add(name);
        }
        return result.toArray(new String[0]);
    }

    public final File[] listFiles(File folder, FilenameFilter filenameFilter) {
        File[] contents = this.listFiles(folder);
        if (filenameFilter == null) {
            return contents;
        }
        ArrayList<File> result = new ArrayList<File>();
        for (File f : contents) {
            if (!filenameFilter.accept(folder, f.getName())) continue;
            result.add(f);
        }
        return result.toArray(new File[0]);
    }

    @Deprecated
    public abstract void deleteOnExit(File var1);

    public final boolean setLastModified(File file, long time) throws IOException {
        return this.setLastModified(this.toPath(file), time);
    }

    public final boolean setLastModified(Path file, long time) throws IOException {
        Files.setLastModifiedTime(file, FileTime.fromMillis(time));
        return true;
    }

    public Path toPath(File file) {
        return this.toPath(file.getPath());
    }

    public Path toPath(String path) {
        return this.getFileSystem().getPath(path, new String[0]);
    }

    public abstract File toFile(Path var1);
}

