/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelBuildFeatures;
import com.android.tools.lint.model.LintModelDependenciesWriter;
import com.android.tools.lint.model.LintModelLibrariesWriter;
import com.android.tools.lint.model.LintModelNamespacingMode;
import com.android.tools.lint.model.LintModelResourceField;
import com.android.tools.lint.model.LintModelSerialization;
import com.android.tools.lint.model.LintModelVariant;
import com.android.tools.lint.model.LintModelWriter;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Comparator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0015\u001a\u00020\n2\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u0018\u001a\u00020\n2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001a0\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J$\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/model/LintModelVariantWriter;", "Lcom/android/tools/lint/model/LintModelWriter;", "adapter", "Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;", "variantName", "", "writer", "Ljava/io/Writer;", "(Lcom/android/tools/lint/model/LintModelSerialization$LintModelSerializationAdapter;Ljava/lang/String;Ljava/io/Writer;)V", "writeArtifact", "", "artifact", "Lcom/android/tools/lint/model/LintModelArtifact;", "tag", "indent", "", "writeDependencies", "", "writeBuildFeatures", "buildFeatures", "Lcom/android/tools/lint/model/LintModelBuildFeatures;", "writeManifestPlaceholders", "manifestPlaceholders", "", "writeResValues", "resValues", "Lcom/android/tools/lint/model/LintModelResourceField;", "writeVariant", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "createdBy", "lint-model"})
final class LintModelVariantWriter
extends LintModelWriter {
    @NotNull
    private final String variantName;

    public LintModelVariantWriter(@NotNull LintModelSerialization.LintModelSerializationAdapter adapter, @NotNull String variantName, @NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        super(adapter, new PrintWriter(writer));
        this.variantName = variantName;
    }

    public /* synthetic */ LintModelVariantWriter(LintModelSerialization.LintModelSerializationAdapter lintModelSerializationAdapter, String string, Writer writer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            writer = LintModelSerialization.LintModelSerializationAdapter.DefaultImpls.getWriter$default(lintModelSerializationAdapter, LintModelSerialization.TargetFile.VARIANT, string, null, 4, null);
        }
        this(lintModelSerializationAdapter, string, writer);
    }

    public final void writeVariant(@NotNull LintModelVariant variant, boolean writeDependencies, @Nullable String createdBy) {
        Object artifact;
        String string;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.setRoot(variant.getModule().getDir());
        int indent = 0;
        this.indent(indent);
        this.getPrinter().print("<variant");
        this.printName(this.getPrinter(), variant.getName(), indent);
        Object object2 = createdBy;
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            this.printAttribute(this.getPrinter(), "createdBy", (String)it, indent);
        }
        if (variant.getUseSupportLibraryVectorDrawables()) {
            this.printAttribute(this.getPrinter(), "useSupportLibraryVectorDrawables", "true", indent);
        }
        if ((object2 = variant.getPackage()) != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            this.printAttribute(this.getPrinter(), "package", (String)it, indent);
        }
        object2 = variant.getMinSdkVersion();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl5 = false;
            PrintWriter printWriter = this.getPrinter();
            string = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiString");
            this.printAttribute(printWriter, "minSdkVersion", string, indent);
        }
        object2 = variant.getTargetSdkVersion();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl6 = false;
            PrintWriter printWriter = this.getPrinter();
            string = it.getApiString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.apiString");
            this.printAttribute(printWriter, "targetSdkVersion", string, indent);
        }
        if (variant.getDebuggable()) {
            this.printAttribute(this.getPrinter(), "debuggable", "true", indent);
        }
        if (variant.getShrinkable()) {
            this.printAttribute(this.getPrinter(), "shrinking", "true", indent);
        }
        if ((object2 = variant.getMergedManifest()) != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl7 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "mergedManifest", (File)it, indent, null, 8, null);
        }
        object2 = variant.getManifestMergeReport();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl8 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "manifestMergeReport", (File)it, indent, null, 8, null);
        }
        LintModelWriter.printFiles$default(this, this.getPrinter(), "proguardFiles", variant.getProguardFiles(), indent, null, 8, null);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "consumerProguardFiles", variant.getConsumerProguardFiles(), indent, null, 8, null);
        LintModelWriter.printStrings$default(this, this.getPrinter(), "resourceConfigurations", variant.getResourceConfigurations(), indent, null, 8, null);
        object2 = variant.getPartialResultsDir();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl9 = false;
            LintModelWriter.printFile$default(this, this.getPrinter(), "partialResultsDir", (File)it, indent, null, 8, null);
        }
        this.getPrinter().println(">");
        this.writeBuildFeatures(variant.getBuildFeatures(), indent + 1);
        this.writeSourceProviders(variant.getSourceProviders(), "sourceProviders", indent + 1);
        this.writeSourceProviders(variant.getTestSourceProviders(), "testSourceProviders", indent + 1);
        this.writeSourceProviders(variant.getTestFixturesSourceProviders(), "testFixturesSourceProviders", indent + 1);
        this.writeResValues(variant.getResValues(), indent + 1);
        this.writeManifestPlaceholders(variant.getManifestPlaceholders(), indent + 1);
        this.writeArtifact(variant.getMainArtifact(), "mainArtifact", indent + 1, writeDependencies);
        object2 = variant.getAndroidTestArtifact();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            artifact = object;
            boolean bl10 = false;
            this.writeArtifact((LintModelArtifact)artifact, "androidTestArtifact", indent + 1, writeDependencies);
        }
        object2 = variant.getTestFixturesArtifact();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            artifact = object;
            boolean bl11 = false;
            this.writeArtifact((LintModelArtifact)artifact, "testFixturesArtifact", indent + 1, writeDependencies);
        }
        object2 = variant.getTestArtifact();
        if (object2 != null) {
            object = object2;
            bl2 = false;
            bl = false;
            artifact = object;
            boolean bl12 = false;
            this.writeArtifact((LintModelArtifact)artifact, "testArtifact", indent + 1, writeDependencies);
        }
        this.indent(indent);
        this.getPrinter().println("</variant>");
        this.getPrinter().close();
    }

    public static /* synthetic */ void writeVariant$default(LintModelVariantWriter lintModelVariantWriter, LintModelVariant lintModelVariant, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            string = null;
        }
        lintModelVariantWriter.writeVariant(lintModelVariant, bl, string);
    }

    private final void writeBuildFeatures(LintModelBuildFeatures buildFeatures, int indent) {
        this.indent(indent);
        this.getPrinter().print("<buildFeatures");
        if (buildFeatures.getCoreLibraryDesugaringEnabled()) {
            this.printAttribute(this.getPrinter(), "coreLibraryDesugaring", "true", indent);
        }
        if (buildFeatures.getViewBinding()) {
            this.printAttribute(this.getPrinter(), "viewBinding", "true", indent);
        }
        if (buildFeatures.getNamespacingMode() != LintModelNamespacingMode.DISABLED) {
            this.printAttribute(this.getPrinter(), "namespacing", buildFeatures.getNamespacingMode().name(), indent);
        }
        this.getPrinter().println("/>");
    }

    private final void writeManifestPlaceholders(Map<String, String> manifestPlaceholders, int indent) {
        if (manifestPlaceholders.isEmpty()) {
            return;
        }
        this.indent(indent);
        this.getPrinter().println("<manifestPlaceholders>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(manifestPlaceholders);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            String key = (String)it.getKey();
            String value = (String)it.getValue();
            this.indent(indent + 1);
            this.getPrinter().print("<placeholder");
            this.printName(this.getPrinter(), key, indent + 1);
            this.printAttribute(this.getPrinter(), "value", value, indent + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent);
        this.getPrinter().println("</manifestPlaceholders>");
    }

    private final void writeResValues(Map<String, ? extends LintModelResourceField> resValues, int indent) {
        if (resValues.isEmpty()) {
            return;
        }
        this.indent(indent);
        this.getPrinter().println("<resValues>");
        Sequence $this$sortedBy$iv = MapsKt.asSequence(resValues);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        Sequence $this$forEach$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                Map.Entry it = (Map.Entry)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                it = (Map.Entry)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = (String)it.getKey();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl2 = false;
            this.indent(indent + 1);
            this.getPrinter().print("<resValue");
            LintModelResourceField resourceField = (LintModelResourceField)it.getValue();
            this.printAttribute(this.getPrinter(), "type", resourceField.getType(), indent + 1);
            this.printName(this.getPrinter(), resourceField.getName(), indent + 1);
            this.printAttribute(this.getPrinter(), "value", resourceField.getValue(), indent + 1);
            this.getPrinter().println(" />");
        }
        this.indent(indent);
        this.getPrinter().println("</resValues>");
    }

    private final void writeArtifact(LintModelArtifact artifact, String tag, int indent, boolean writeDependencies) {
        this.indent(indent);
        this.getPrinter().print("<");
        this.getPrinter().print(tag);
        LintModelWriter.printFiles$default(this, this.getPrinter(), "classOutputs", artifact.getClassOutputs(), indent, null, 8, null);
        if (artifact instanceof LintModelAndroidArtifact) {
            this.printAttribute(this.getPrinter(), "applicationId", ((LintModelAndroidArtifact)artifact).getApplicationId(), indent);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedSourceFolders", ((LintModelAndroidArtifact)artifact).getGeneratedSourceFolders(), indent, null, 8, null);
            LintModelWriter.printFiles$default(this, this.getPrinter(), "generatedResourceFolders", ((LintModelAndroidArtifact)artifact).getGeneratedResourceFolders(), indent, null, 8, null);
        }
        this.getPrinter().println(">");
        this.indent(indent);
        this.getPrinter().print("</");
        this.getPrinter().print(tag);
        this.getPrinter().println(">");
        if (writeDependencies) {
            LintModelDependenciesWriter dependencyWriter = new LintModelDependenciesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            dependencyWriter.writeDependencies(artifact.getDependencies());
            LintModelLibrariesWriter libraryWriter = new LintModelLibrariesWriter(this.getAdapter(), this.variantName, tag, null, 8, null);
            libraryWriter.writeLibraries(artifact.getDependencies().getLibraryResolver(), artifact.getDependencies());
        }
    }
}

