/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing.utp;

import com.android.build.api.instrumentation.StaticTestData;
import com.android.build.gradle.internal.testing.utp.UtpManagedDevice;
import com.android.builder.testing.api.DeviceConnector;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.MultiLineReceiver;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "Lorg/gradle/api/logging/Logger;", "ADDITIONAL_TEST_OUTPUT_MIN_API_LEVEL", "", "findAdditionalTestOutputDirectoryOnDevice", "", "device", "Lcom/android/builder/testing/api/DeviceConnector;", "testData", "Lcom/android/build/api/instrumentation/StaticTestData;", "findAdditionalTestOutputDirectoryOnManagedDevice", "Lcom/android/build/gradle/internal/testing/utp/UtpManagedDevice;", "queryAdditionalTestOutputLocation", "gradle-core"})
public final class AdditionalTestOutputUtilsKt {
    private static final Logger logger = Logging.getLogger((String)"AdditionalTestOutputUtils");
    public static final int ADDITIONAL_TEST_OUTPUT_MIN_API_LEVEL = 16;

    @Nullable
    public static final String findAdditionalTestOutputDirectoryOnDevice(@NotNull DeviceConnector device, @NotNull StaticTestData testData) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
        if (device.getApiLevel() < 16) {
            logger.warn("additionalTestOutput is not supported on devices running API level < 16");
            return null;
        }
        String userSpecifiedDir = (String)testData.getInstrumentationRunnerArguments().get("additionalTestOutputDir");
        if (userSpecifiedDir != null) {
            return userSpecifiedDir;
        }
        if (device.getApiLevel() >= 29) {
            return "/sdcard/Android/media/" + testData.getInstrumentationTargetPackageId() + "/additional_test_output";
        }
        String additionalTestOutputLocation = AdditionalTestOutputUtilsKt.queryAdditionalTestOutputLocation(device, testData);
        if (additionalTestOutputLocation == null) {
            logger.warn("additionalTestOutput is not supported on this device running API level " + device.getApiLevel() + " because the additional test output directory could not be found");
            return null;
        }
        return additionalTestOutputLocation + "/data/" + testData.getInstrumentationTargetPackageId() + "/files/test_data";
    }

    @Nullable
    public static final String findAdditionalTestOutputDirectoryOnManagedDevice(@NotNull UtpManagedDevice device, @NotNull StaticTestData testData) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)testData, (String)"testData");
        if (device.getApi() < 16) {
            logger.warn("additionalTestOutput is not supported on devices running API level < 16");
            return null;
        }
        String userSpecifiedDir = (String)testData.getInstrumentationRunnerArguments().get("additionalTestOutputDir");
        if (userSpecifiedDir != null) {
            return userSpecifiedDir;
        }
        if (device.getApi() < 29) {
            logger.warn("additionalTestOutput is not supported on Gradle managed devices running API level < 29");
            return null;
        }
        return "/sdcard/Android/media/" + testData.getInstrumentationTargetPackageId() + "/additional_test_output";
    }

    private static final String queryAdditionalTestOutputLocation(DeviceConnector device, StaticTestData testData) {
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        MultiLineReceiver receiver2 = new MultiLineReceiver((Ref.ObjectRef<String>)result2){
            final /* synthetic */ Ref.ObjectRef<String> $result;
            {
                this.$result = $result;
            }

            /*
             * WARNING - void declaration
             */
            public void processNewLines(String[] lines) {
                Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
                for (String row : lines) {
                    void $this$trim$iv;
                    if (((CharSequence)row).length() == 0 || !StringsKt.startsWith$default((String)row, (String)"Row:", (boolean)false, (int)2, null)) break;
                    String[] stringArray = new String[]{"_data="};
                    Object $this$toTypedArray$iv = StringsKt.split$default((CharSequence)row, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    $this$toTypedArray$iv = thisCollection$iv.toArray(new String[0])[1];
                    Ref.ObjectRef<String> objectRef = this.$result;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    objectRef.element = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
            }

            public boolean isCancelled() {
                return false;
            }
        };
        device.executeShellCommand("content query --uri content://media/external/file --projection _data --where \"_data LIKE '%/Android'\"", (IShellOutputReceiver)receiver2, (long)DdmPreferences.getTimeOut(), TimeUnit.MILLISECONDS);
        receiver2.flush();
        return (String)result2.element;
    }
}

