/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.testing;

import com.android.build.gradle.internal.testing.EmulatorVersionMetadata;
import com.android.ide.common.gradle.Version;
import java.io.File;
import java.nio.file.Files;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"SNAPSHOT_LOADABLE_VERSION", "Lcom/android/ide/common/gradle/Version;", "FORCE_SNAPSHOT_LOAD_VERSION", "versionPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "getEmulatorMetadata", "Lcom/android/build/gradle/internal/testing/EmulatorVersionMetadata;", "emulatorDir", "Ljava/io/File;", "gradle-core"})
public final class EmulatorVersionUtilsKt {
    @NotNull
    private static final Version SNAPSHOT_LOADABLE_VERSION = Version.Companion.parse("30.6.4");
    @NotNull
    private static final Version FORCE_SNAPSHOT_LOAD_VERSION = Version.Companion.parse("34.2.14");
    private static final Pattern versionPattern = Pattern.compile("<major>(\\d+)</major><minor>(\\d+)</minor><micro>(\\d+)</micro>");

    @NotNull
    public static final EmulatorVersionMetadata getEmulatorMetadata(@NotNull File emulatorDir) {
        Intrinsics.checkNotNullParameter((Object)emulatorDir, (String)"emulatorDir");
        int foundMajorVersion = -1;
        int foundMinorVersion = -1;
        int foundMicroVersion = -1;
        File packageFile = FilesKt.resolve((File)emulatorDir, (String)"package.xml");
        for (String line : Files.readAllLines(packageFile.toPath())) {
            Matcher matcher = versionPattern.matcher(line);
            if (!matcher.find()) continue;
            String string = matcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            foundMajorVersion = Integer.parseInt(string);
            String string2 = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            foundMinorVersion = Integer.parseInt(string2);
            String string3 = matcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
            foundMicroVersion = Integer.parseInt(string3);
            break;
        }
        if (foundMajorVersion == -1) {
            throw new IllegalStateException(("Could not determine version of Emulator in " + emulatorDir.getAbsolutePath() + ". Update emulator in order to use Managed Devices.").toString());
        }
        Version version = Version.Companion.parse(foundMajorVersion + "." + foundMinorVersion + "." + foundMicroVersion);
        if (version.compareTo(SNAPSHOT_LOADABLE_VERSION) < 0) {
            throw new IllegalStateException(("Emulator needs to be updated in order to use managed devices. Minimum version required: " + SNAPSHOT_LOADABLE_VERSION + ". Version found: " + version).toString());
        }
        return new EmulatorVersionMetadata(version.compareTo(FORCE_SNAPSHOT_LOAD_VERSION) >= 0);
    }
}

