/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.ndk;

import com.android.build.gradle.internal.cxx.configure.NdkLocator;
import com.android.build.gradle.internal.cxx.configure.NdkLocatorRecord;
import com.android.build.gradle.internal.ndk.DefaultNdkInfo;
import com.android.build.gradle.internal.ndk.NdkInfo;
import com.android.build.gradle.internal.ndk.NdkInstallStatus;
import com.android.build.gradle.internal.ndk.NdkPlatform;
import com.android.build.gradle.internal.ndk.NdkR14Info;
import com.android.build.gradle.internal.ndk.NdkR17Info;
import com.android.build.gradle.internal.ndk.NdkR18Info;
import com.android.build.gradle.internal.ndk.NdkR19Info;
import com.android.build.gradle.internal.ndk.NdkR21Info;
import com.android.build.gradle.internal.ndk.NdkR25Info;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/android/build/gradle/internal/ndk/NdkHandler;", "", "ndkLocator", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocator;", "<init>", "(Lcom/android/build/gradle/internal/cxx/configure/NdkLocator;)V", "ndkInstallStatus", "Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "getNdkInfo", "Lcom/android/build/gradle/internal/ndk/NdkInfo;", "ndk", "Lcom/android/build/gradle/internal/cxx/configure/NdkLocatorRecord;", "getNdkStatus", "downloadOkay", "", "getNdkPlatform", "ndkPlatform", "()Lcom/android/build/gradle/internal/ndk/NdkInstallStatus;", "gradle-core"})
public class NdkHandler {
    @NotNull
    private final NdkLocator ndkLocator;
    @Nullable
    private NdkInstallStatus ndkInstallStatus;

    public NdkHandler(@NotNull NdkLocator ndkLocator) {
        Intrinsics.checkNotNullParameter((Object)ndkLocator, (String)"ndkLocator");
        this.ndkLocator = ndkLocator;
    }

    private final NdkInfo getNdkInfo(NdkLocatorRecord ndk) {
        return ndk.getRevision().getMajor() >= 25 ? (NdkInfo)new NdkR25Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 21 ? (NdkInfo)new NdkR21Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 19 ? (NdkInfo)new NdkR19Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 18 ? (NdkInfo)new NdkR18Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 17 ? (NdkInfo)new NdkR17Info(ndk.getNdk()) : (ndk.getRevision().getMajor() >= 14 ? (NdkInfo)new NdkR14Info(ndk.getNdk()) : (NdkInfo)new DefaultNdkInfo(ndk.getNdk()))))));
    }

    private final NdkInstallStatus getNdkStatus(boolean downloadOkay) {
        NdkLocatorRecord ndkLocatorRecord = this.ndkLocator.findNdkPath(downloadOkay);
        if (ndkLocatorRecord == null) {
            return NdkInstallStatus.NotInstalled.INSTANCE;
        }
        NdkLocatorRecord ndk = ndkLocatorRecord;
        NdkInfo ndkInfo = this.getNdkInfo(ndk);
        String error = ndkInfo.validate();
        if (error != null) {
            return new NdkInstallStatus.Invalid(error);
        }
        return new NdkInstallStatus.Valid(new NdkPlatform(ndk.getNdk(), ndkInfo, ndk.getRevision()));
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform(boolean downloadOkay) {
        if (this.ndkInstallStatus == null || downloadOkay && Intrinsics.areEqual((Object)this.ndkInstallStatus, (Object)NdkInstallStatus.NotInstalled.INSTANCE)) {
            this.ndkInstallStatus = this.getNdkStatus(downloadOkay);
        }
        NdkInstallStatus ndkInstallStatus = this.ndkInstallStatus;
        Intrinsics.checkNotNull((Object)ndkInstallStatus);
        return ndkInstallStatus;
    }

    @NotNull
    public final NdkInstallStatus getNdkPlatform() {
        return this.getNdkPlatform(false);
    }
}

