/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.utils;

import com.android.build.api.variant.impl.AndroidVersionImpl;
import com.android.build.gradle.internal.utils.CompileData;
import com.android.builder.core.DefaultApiVersion;
import com.android.sdklib.AndroidVersion;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a#\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a2\u0006\u0002\u0010\n\u001a\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t\u001a\u0010\u0010\u000e\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000f\u001a\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"ADDON_PATTERN", "Ljava/util/regex/Pattern;", "API_PATTERN", "FULL_PREVIEW_PATTERN", "createTargetSdkVersion", "Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "targetSdk", "", "targetSdkPreview", "", "(Ljava/lang/Integer;Ljava/lang/String;)Lcom/android/build/api/variant/impl/AndroidVersionImpl;", "parseTargetHash", "Lcom/android/build/gradle/internal/utils/CompileData;", "targetHash", "validatePreviewTargetValue", "value", "gradle-core"})
@SourceDebugExtension(value={"SMAP\nSdkUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SdkUtils.kt\ncom/android/build/gradle/internal/utils/SdkUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,84:1\n1#2:85\n*E\n"})
public final class SdkUtilsKt {
    @NotNull
    private static final Pattern API_PATTERN;
    @NotNull
    private static final Pattern FULL_PREVIEW_PATTERN;
    @NotNull
    private static final Pattern ADDON_PATTERN;

    @NotNull
    public static final CompileData parseTargetHash(@NotNull String targetHash) {
        Intrinsics.checkNotNullParameter((Object)targetHash, (String)"targetHash");
        Matcher apiMatcher = API_PATTERN.matcher(targetHash);
        if (apiMatcher.matches()) {
            String string = apiMatcher.group(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apiMatcher.group(1)");
            String string2 = apiMatcher.group(3);
            return new CompileData(Integer.parseInt(string), null, string2 != null ? StringsKt.toIntOrNull((String)string2) : null, null, null, 26, null);
        }
        Matcher previewMatcher = FULL_PREVIEW_PATTERN.matcher(targetHash);
        if (previewMatcher.matches()) {
            return new CompileData(null, previewMatcher.group(1), null, null, null, 29, null);
        }
        Matcher addonMatcher = ADDON_PATTERN.matcher(targetHash);
        if (addonMatcher.matches()) {
            String string = addonMatcher.group(1);
            String string3 = addonMatcher.group(2);
            String string4 = addonMatcher.group(3);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"addonMatcher.group(3)");
            int n = Integer.parseInt(string4);
            return new CompileData(n, null, null, string, string3, 6, null);
        }
        throw new RuntimeException(StringsKt.trimIndent((String)("\n                    Unsupported value: " + targetHash + ". Format must be one of:\n                    - android-31\n                    - android-31-ext2\n                    - android-T\n                    - vendorName:addonName:31\n                    ")));
    }

    @Nullable
    public static final String validatePreviewTargetValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AndroidVersion.PREVIEW_PATTERN.matcher(value).matches() ? value : null;
    }

    @Nullable
    public static final AndroidVersionImpl createTargetSdkVersion(@Nullable Integer targetSdk2, @Nullable String targetSdkPreview) {
        AndroidVersionImpl androidVersionImpl;
        if (targetSdk2 != null || targetSdkPreview != null) {
            DefaultApiVersion apiVersion;
            DefaultApiVersion defaultApiVersion;
            Integer n = targetSdk2;
            if (n != null) {
                int it = ((Number)n).intValue();
                boolean bl = false;
                defaultApiVersion = new DefaultApiVersion(it);
            } else {
                String string = targetSdkPreview;
                Intrinsics.checkNotNull((Object)string);
                defaultApiVersion = new DefaultApiVersion(string);
            }
            DefaultApiVersion $this$createTargetSdkVersion_u24lambda_u241 = apiVersion = defaultApiVersion;
            boolean bl = false;
            androidVersionImpl = new AndroidVersionImpl($this$createTargetSdkVersion_u24lambda_u241.getApiLevel(), $this$createTargetSdkVersion_u24lambda_u241.getCodename());
        } else {
            androidVersionImpl = null;
        }
        return androidVersionImpl;
    }

    static {
        Pattern pattern = Pattern.compile("^android-([0-9]+)(-ext(\\d+))?$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"^android-([0-9]+)(-ext(\\\\d+))?$\")");
        API_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("^android-([A-Z][0-9A-Za-z_]*)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(\"^android-([A-Z][0-9A-Za-z_]*)$\")");
        FULL_PREVIEW_PATTERN = pattern2;
        Pattern pattern3 = Pattern.compile("^(.+):(.+):(\\d+)$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern3, (String)"compile(\"^(.+):(.+):(\\\\d+)$\")");
        ADDON_PATTERN = pattern3;
    }
}

