/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.dependency.GenericTransformParameters;
import com.android.build.gradle.internal.services.Aapt2Daemon;
import com.android.build.gradle.internal.services.Aapt2Input;
import com.android.build.gradle.internal.signing.SigningConfigData;
import com.android.build.gradle.internal.tasks.BundleTaskUtil;
import com.android.tools.build.bundletool.androidtools.Aapt2Command;
import com.android.tools.build.bundletool.commands.BuildSdkApksCommand;
import com.android.utils.PathUtils;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.artifacts.transform.CacheableTransform;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.jetbrains.annotations.NotNull;

@CacheableTransform
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H'J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToApksTransform;", "Lorg/gradle/api/artifacts/transform/TransformAction;", "Lcom/android/build/gradle/internal/tasks/AsarToApksTransform$AsarToApksTransformParameters;", "()V", "getInputArtifact", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/FileSystemLocation;", "transform", "", "outputs", "Lorg/gradle/api/artifacts/transform/TransformOutputs;", "AsarToApksTransformParameters", "gradle-core"})
public abstract class AsarToApksTransform
implements TransformAction<AsarToApksTransformParameters> {
    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    @NotNull
    public abstract Provider<FileSystemLocation> getInputArtifact();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(@NotNull TransformOutputs outputs2) {
        Intrinsics.checkNotNullParameter((Object)outputs2, (String)"outputs");
        Path inputFile = ((FileSystemLocation)this.getInputArtifact().get()).getAsFile().toPath();
        Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
        Path outputFile = outputs2.file((Object)(PathsKt.getNameWithoutExtension((Path)inputFile) + ".apks")).toPath();
        Path tempDir = Files.createTempDirectory("asb", new FileAttribute[0]);
        try {
            Path renamedInputFile = tempDir.resolve(StringsKt.substringBeforeLast$default((String)((Object)inputFile.getFileName()).toString(), (char)'.', null, (int)2, null) + ".asb");
            Files.copy(inputFile, renamedInputFile, new CopyOption[0]);
            Path aapt2Executable = Aapt2Daemon.getAapt2Executable(((AsarToApksTransformParameters)this.getParameters()).getAapt2()).toFile().toPath();
            SigningConfigData signingConfigData = (SigningConfigData)((AsarToApksTransformParameters)this.getParameters()).getSigningConfigData().get();
            BuildSdkApksCommand.Builder builder = BuildSdkApksCommand.builder().setExecutorService(MoreExecutors.listeningDecorator((ExecutorService)ForkJoinPool.commonPool())).setSdkBundlePath(renamedInputFile).setOutputFile(outputFile).setAapt2Command(Aapt2Command.createFromExecutablePath((Path)aapt2Executable));
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"builder()\n              \u2026blePath(aapt2Executable))");
            Intrinsics.checkNotNullExpressionValue((Object)signingConfigData, (String)"signingConfigData");
            BuildSdkApksCommand.Builder command = BundleTaskUtil.setSigningConfiguration(builder, signingConfigData).setVersionCode(Integer.valueOf(1)).setMinSdkVersion(33);
            command.build().execute();
        }
        finally {
            PathUtils.deleteRecursivelyIfExists((Path)tempDir);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u00020\u00038gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f\u00c0\u0006\u0003"}, d2={"Lcom/android/build/gradle/internal/tasks/AsarToApksTransform$AsarToApksTransformParameters;", "Lcom/android/build/gradle/internal/dependency/GenericTransformParameters;", "aapt2", "Lcom/android/build/gradle/internal/services/Aapt2Input;", "getAapt2", "()Lcom/android/build/gradle/internal/services/Aapt2Input;", "signingConfigData", "Lorg/gradle/api/provider/Property;", "Lcom/android/build/gradle/internal/signing/SigningConfigData;", "getSigningConfigData", "()Lorg/gradle/api/provider/Property;", "signingConfigValidationResultDir", "Lorg/gradle/api/file/DirectoryProperty;", "getSigningConfigValidationResultDir", "()Lorg/gradle/api/file/DirectoryProperty;", "gradle-core"})
    public static interface AsarToApksTransformParameters
    extends GenericTransformParameters {
        @Nested
        @NotNull
        public Aapt2Input getAapt2();

        @Nested
        @NotNull
        public Property<SigningConfigData> getSigningConfigData();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NONE)
        @NotNull
        public DirectoryProperty getSigningConfigValidationResultDir();
    }
}

