/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.Version;
import com.android.build.api.artifact.impl.ArtifactsImpl;
import com.android.build.gradle.internal.component.ApplicationCreationConfig;
import com.android.build.gradle.internal.component.ComponentCreationConfig;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkInternalArtifactType;
import com.android.build.gradle.internal.privaysandboxsdk.PrivacySandboxSdkVariantScope;
import com.android.build.gradle.internal.tasks.AppMetadataTask;
import com.android.build.gradle.internal.tasks.AppMetadataTaskKt;
import com.android.build.gradle.internal.tasks.BuildAnalyzer;
import com.android.build.gradle.internal.tasks.NonIncrementalTask;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.internal.tasks.VariantAwareTaskKt;
import com.android.build.gradle.internal.tasks.factory.TaskCreationAction;
import com.android.build.gradle.internal.tasks.factory.VariantTaskCreationAction;
import com.android.build.gradle.internal.utils.HasConfigurableValuesKt;
import com.android.build.gradle.options.ProjectOptions;
import com.android.build.gradle.options.StringOption;
import com.android.buildanalyzer.common.TaskCategory;
import com.android.utils.FileUtils;
import com.google.common.io.Files;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.services.BuildServiceRegistry;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault
@BuildAnalyzer(primaryTaskCategory=TaskCategory.METADATA)
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 \u00152\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0014R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "Lcom/android/build/gradle/internal/tasks/NonIncrementalTask;", "()V", "agdeVersion", "Lorg/gradle/api/provider/Property;", "", "getAgdeVersion", "()Lorg/gradle/api/provider/Property;", "agpVersion", "getAgpVersion", "appMetadataVersion", "getAppMetadataVersion", "outputFile", "Lorg/gradle/api/file/RegularFileProperty;", "getOutputFile", "()Lorg/gradle/api/file/RegularFileProperty;", "configureTaskInputs", "", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "doTaskAction", "Companion", "CreationAction", "CreationForAssetPackBundleAction", "PrivacySandboxSdkCreationAction", "gradle-core"})
public abstract class AppMetadataTask
extends NonIncrementalTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String APP_METADATA_VERSION = "1.1";

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getOutputFile();

    @Input
    @NotNull
    public abstract Property<String> getAppMetadataVersion();

    @Input
    @NotNull
    public abstract Property<String> getAgpVersion();

    @Input
    @Optional
    @NotNull
    public abstract Property<String> getAgdeVersion();

    @Override
    protected void doTaskAction() {
        File appMetadataFile = ((RegularFile)this.getOutputFile().get()).getAsFile();
        FileUtils.deleteIfExists((File)appMetadataFile);
        Files.createParentDirs((File)appMetadataFile);
        Intrinsics.checkNotNullExpressionValue((Object)appMetadataFile, (String)"appMetadataFile");
        Object object = this.getAppMetadataVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appMetadataVersion.get()");
        String string = (String)object;
        Object object2 = this.getAgpVersion().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"agpVersion.get()");
        AppMetadataTaskKt.access$writeAppMetadataFile(appMetadataFile, string, (String)object2, (String)this.getAgdeVersion().getOrNull());
    }

    private final void configureTaskInputs(ProjectOptions projectOptions) {
        HasConfigurableValuesKt.setDisallowChanges(this.getAppMetadataVersion(), APP_METADATA_VERSION);
        HasConfigurableValuesKt.setDisallowChanges(this.getAgpVersion(), Version.ANDROID_GRADLE_PLUGIN_VERSION);
        Property<String> property = this.getAgdeVersion();
        Provider<String> provider2 = projectOptions.getProvider(StringOption.IDE_AGDE_VERSION);
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"projectOptions.getProvid\u2026gOption.IDE_AGDE_VERSION)");
        HasConfigurableValuesKt.setDisallowChanges(property, provider2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$Companion;", "", "()V", "APP_METADATA_VERSION", "", "gradle-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$CreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/VariantTaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;", "creationConfig", "(Lcom/android/build/gradle/internal/component/ApplicationCreationConfig;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationAction
    extends VariantTaskCreationAction<AppMetadataTask, ApplicationCreationConfig> {
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public CreationAction(@NotNull ApplicationCreationConfig creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            super((ComponentCreationConfig)creationConfig);
            this.type = AppMetadataTask.class;
            this.name = this.computeTaskName("write", "AppMetadata");
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            AppMetadataTaskKt.access$configureTaskOutputs(taskProvider, ((ApplicationCreationConfig)this.creationConfig).getArtifacts());
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            super.configure((Task)task);
            task.configureTaskInputs(((ApplicationCreationConfig)this.creationConfig).getServices().getProjectOptions());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0002H\u0016J\u0016\u0010\u0013\u001a\u00020\u00112\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$CreationForAssetPackBundleAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "artifacts", "Lcom/android/build/api/artifact/impl/ArtifactsImpl;", "projectOptions", "Lcom/android/build/gradle/options/ProjectOptions;", "(Lcom/android/build/api/artifact/impl/ArtifactsImpl;Lcom/android/build/gradle/options/ProjectOptions;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class CreationForAssetPackBundleAction
    extends TaskCreationAction<AppMetadataTask> {
        @NotNull
        private final ArtifactsImpl artifacts;
        @NotNull
        private final ProjectOptions projectOptions;
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public CreationForAssetPackBundleAction(@NotNull ArtifactsImpl artifacts2, @NotNull ProjectOptions projectOptions) {
            Intrinsics.checkNotNullParameter((Object)artifacts2, (String)"artifacts");
            Intrinsics.checkNotNullParameter((Object)projectOptions, (String)"projectOptions");
            this.artifacts = artifacts2;
            this.projectOptions = projectOptions;
            this.type = AppMetadataTask.class;
            this.name = "writeAppMetadata";
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            AppMetadataTaskKt.access$configureTaskOutputs(taskProvider, this.artifacts);
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            VariantAwareTask variantAwareTask = task;
            BuildServiceRegistry buildServiceRegistry = task.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"task.project.gradle.sharedServices");
            VariantAwareTaskKt.configureVariantProperties(variantAwareTask, "", buildServiceRegistry);
            task.configureTaskInputs(this.projectOptions);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0016\u0010\u0011\u001a\u00020\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/android/build/gradle/internal/tasks/AppMetadataTask$PrivacySandboxSdkCreationAction;", "Lcom/android/build/gradle/internal/tasks/factory/TaskCreationAction;", "Lcom/android/build/gradle/internal/tasks/AppMetadataTask;", "creationConfig", "Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;", "(Lcom/android/build/gradle/internal/privaysandboxsdk/PrivacySandboxSdkVariantScope;)V", "name", "", "getName", "()Ljava/lang/String;", "type", "Ljava/lang/Class;", "getType", "()Ljava/lang/Class;", "configure", "", "task", "handleProvider", "taskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "gradle-core"})
    public static final class PrivacySandboxSdkCreationAction
    extends TaskCreationAction<AppMetadataTask> {
        @NotNull
        private final PrivacySandboxSdkVariantScope creationConfig;
        @NotNull
        private final Class<AppMetadataTask> type;
        @NotNull
        private final String name;

        public PrivacySandboxSdkCreationAction(@NotNull PrivacySandboxSdkVariantScope creationConfig) {
            Intrinsics.checkNotNullParameter((Object)creationConfig, (String)"creationConfig");
            this.creationConfig = creationConfig;
            this.type = AppMetadataTask.class;
            this.name = "writeAppMetadata";
        }

        @Override
        @NotNull
        public Class<AppMetadataTask> getType() {
            return this.type;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        public void handleProvider(@NotNull TaskProvider<AppMetadataTask> taskProvider) {
            Intrinsics.checkNotNullParameter(taskProvider, (String)"taskProvider");
            super.handleProvider(taskProvider);
            this.creationConfig.getArtifacts().setInitialProvider(taskProvider, (Function1)handleProvider.1.INSTANCE).withName("app-metadata.properties").on(PrivacySandboxSdkInternalArtifactType.APP_METADATA.INSTANCE);
        }

        @Override
        public void configure(@NotNull AppMetadataTask task) {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            VariantAwareTask variantAwareTask = task;
            BuildServiceRegistry buildServiceRegistry = task.getProject().getGradle().getSharedServices();
            Intrinsics.checkNotNullExpressionValue((Object)buildServiceRegistry, (String)"task.project.gradle.sharedServices");
            VariantAwareTaskKt.configureVariantProperties(variantAwareTask, "", buildServiceRegistry);
            task.configureTaskInputs(this.creationConfig.getServices().getProjectOptions());
        }
    }
}

