/*
 * Decompiled with CFR 0.152.
 */
package com.android.signflinger;

import com.android.apksig.ApkSignerEngine;
import com.android.apksig.DefaultApkSignerEngine;
import com.android.apksig.apk.ApkFormatException;
import com.android.apksig.internal.util.FileChannelDataSource;
import com.android.apksig.util.DataSource;
import com.android.apksig.util.DataSources;
import com.android.signflinger.ApkSigningBlock;
import com.android.signflinger.SignedApkOptions;
import com.android.signflinger.SigningBlockUtils;
import com.android.zipflinger.Archive;
import com.android.zipflinger.BytesSource;
import com.android.zipflinger.Source;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipArchive;
import com.android.zipflinger.ZipInfo;
import com.android.zipflinger.ZipSource;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class SignedApk
implements Archive {
    static final int DEPENDENCY_INFO_BLOCK_ID = 1347109971;
    private final ZipArchive archive;
    private final ApkSignerEngine signer;
    private final SignedApkOptions options;
    static final String MANIFEST_ENTRY_NAME = "META-INF/MANIFEST.MF";
    static final String MANIFEST_CREATED_BY = "Created-By";
    static final String MANIFEST_BUILT_BY = "Built-By";
    static final String MANIFEST_VERSION = "Manifest-Version";
    private static final boolean FAIL_ON_V4_ERROR = true;

    public SignedApk(File file, SignedApkOptions options) throws InvalidKeyException, IOException {
        this(file, options, Zip64.Policy.FORBID);
    }

    public SignedApk(File file, SignedApkOptions options, Zip64.Policy zip64Policy) throws InvalidKeyException, IOException {
        this.options = options;
        this.archive = new ZipArchive(file.toPath(), zip64Policy);
        DefaultApkSignerEngine.SignerConfig signerConfig = new DefaultApkSignerEngine.SignerConfig.Builder(options.name, options.privateKey, options.certificates).build();
        ArrayList<DefaultApkSignerEngine.SignerConfig> signerConfigs = new ArrayList<DefaultApkSignerEngine.SignerConfig>();
        signerConfigs.add(signerConfig);
        this.signer = new DefaultApkSignerEngine.Builder(signerConfigs, options.minSdkVersion).setV1SigningEnabled(options.v1Enabled).setV2SigningEnabled(options.v2Enabled).setV3SigningEnabled(options.v3Enabled).setSigningCertificateLineage(options.v3SigningCertificateLineage).setCreatedBy(options.v1CreatedBy).setOtherSignersSignaturesPreserved(false).build();
        if (options.executor != null) {
            this.signer.setExecutor(options.executor);
        }
        this.initWithV1();
    }

    private void initWithV1() throws IOException {
        byte[] manifestBytes;
        ByteBuffer manifestByteBuffer;
        if (!this.options.v1Enabled) {
            return;
        }
        if (!this.options.v1TrustManifest) {
            this.archive.delete(MANIFEST_ENTRY_NAME);
        }
        if ((manifestByteBuffer = this.archive.getContent(MANIFEST_ENTRY_NAME)) != null) {
            manifestBytes = new byte[manifestByteBuffer.remaining()];
            manifestByteBuffer.get(manifestBytes);
        } else {
            manifestBytes = this.createDefaultManifest();
            BytesSource bytesSource = new BytesSource(manifestBytes, MANIFEST_ENTRY_NAME, 0);
            this.archive.add((Source)bytesSource);
        }
        HashSet filesToSign = new HashSet(this.archive.listEntries());
        Set signedEntries = this.signer.initWith(manifestBytes, filesToSign);
        filesToSign.removeAll(signedEntries);
        for (String entryName : filesToSign) {
            ApkSignerEngine.InspectJarEntryRequest req = this.signer.outputJarEntry(entryName);
            this.processRequest(req);
        }
    }

    public void add(Source source) throws IOException {
        this.archive.add(source);
        if (this.options.v1Enabled) {
            ApkSignerEngine.InspectJarEntryRequest req = this.signer.outputJarEntry(source.getName());
            this.processRequest(req);
        }
    }

    public void add(ZipSource sources) throws IOException {
        this.archive.add(sources);
        if (this.options.v1Enabled) {
            for (Source source : sources.getSelectedEntries()) {
                ApkSignerEngine.InspectJarEntryRequest req = this.signer.outputJarEntry(source.getName());
                this.processRequest(req);
            }
        }
    }

    public void delete(String name) {
        this.archive.delete(name);
        if (this.options.v1Enabled) {
            this.signer.outputJarEntryRemoved(name);
        }
    }

    public void close() throws IOException {
        try {
            this.finishSigning();
            this.signV4();
        }
        finally {
            this.signer.close();
        }
    }

    private void finishSigning() throws IOException {
        try {
            this.finishV1();
            this.finishV2andV3();
        }
        finally {
            if (!this.archive.isClosed()) {
                this.archive.close();
            }
        }
    }

    private void signV4() throws IOException {
        if (!this.options.v4Enabled) {
            return;
        }
        Path path = this.archive.getPath();
        try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
            FileChannelDataSource dataSource = new FileChannelDataSource(channel);
            this.signer.signV4((DataSource)dataSource, this.options.v4Output, true);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException("V4 Signing error", e);
        }
    }

    private byte[] createDefaultManifest() throws IOException {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.putValue(MANIFEST_CREATED_BY, this.options.v1CreatedBy);
        mainAttributes.putValue(MANIFEST_BUILT_BY, this.options.v1BuiltBy);
        mainAttributes.putValue(MANIFEST_VERSION, "1.0");
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        manifest.write(os);
        return os.toByteArray();
    }

    private void finishV2andV3() throws IOException {
        if (!this.options.v2Enabled && !this.options.v3Enabled) {
            return;
        }
        ZipInfo zipInfo = this.archive.closeWithInfo();
        try (RandomAccessFile raf = new RandomAccessFile(this.archive.getPath().toFile(), "rw");){
            byte[] sigBlock = this.v2andV3Sign(raf, zipInfo);
            sigBlock = SigningBlockUtils.addToSigningBlock(sigBlock, this.options.sdkDependencies, 1347109971);
            ApkSigningBlock.addToArchive(raf, sigBlock, zipInfo);
        }
        catch (ApkFormatException | IOException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new IllegalStateException(e);
        }
    }

    private void processRequest(ApkSignerEngine.InspectJarEntryRequest req) throws IOException {
        if (req == null) {
            return;
        }
        String name = req.getEntryName();
        ByteBuffer content = this.archive.getContent(name);
        if (content == null) {
            String err = String.format("Cannot find and therefore inspect entry %s.", name);
            throw new IllegalStateException(err);
        }
        req.getDataSink().consume(content);
        req.done();
    }

    private void finishV1() throws IOException {
        ApkSignerEngine.OutputJarSignatureRequest addV1SignatureRequest;
        if (!this.options.v1Enabled) {
            return;
        }
        try {
            addV1SignatureRequest = this.signer.outputJarEntries();
        }
        catch (Exception e) {
            throw new IOException("Failed to generate v1 signature", e);
        }
        if (addV1SignatureRequest == null) {
            return;
        }
        for (ApkSignerEngine.OutputJarSignatureRequest.JarEntry entry : addV1SignatureRequest.getAdditionalJarEntries()) {
            this.archive.delete(entry.getName());
            BytesSource source = new BytesSource(entry.getData(), entry.getName(), 1);
            this.archive.add((Source)source);
            ApkSignerEngine.InspectJarEntryRequest request = this.signer.outputJarEntry(entry.getName());
            this.processRequest(request);
        }
        addV1SignatureRequest.done();
    }

    private byte[] v2andV3Sign(RandomAccessFile raf, ZipInfo zipInfo) throws ApkFormatException, SignatureException, NoSuchAlgorithmException, InvalidKeyException, IOException {
        DataSource beforeCentralDir = DataSources.asDataSource((RandomAccessFile)raf, (long)zipInfo.payload.first, (long)zipInfo.payload.size());
        DataSource centralDir = DataSources.asDataSource((RandomAccessFile)raf, (long)zipInfo.cd.first, (long)zipInfo.cd.size());
        DataSource eocd = DataSources.asDataSource((RandomAccessFile)raf, (long)zipInfo.eocd.first, (long)zipInfo.eocd.size());
        ApkSignerEngine.OutputApkSigningBlockRequest outputApkSigningBlockRequest = this.signer.outputZipSections(beforeCentralDir, centralDir, eocd);
        outputApkSigningBlockRequest.done();
        return outputApkSigningBlockRequest.getApkSigningBlock();
    }
}

