/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import com.alibaba.android.arouter.launcher.ARouter;

public class PackageUtils {
    public static boolean isNewVersion(Context context) {
        PackageInfo packageInfo = PackageUtils.getPackageInfo(context);
        if (null != packageInfo) {
            String versionName = packageInfo.versionName;
            int versionCode = packageInfo.versionCode;
            SharedPreferences sp = context.getSharedPreferences("SP_AROUTER_CACHE", 0);
            if (!versionName.equals(sp.getString("LAST_VERSION_NAME", null)) || versionCode != sp.getInt("LAST_VERSION_CODE", -1)) {
                sp.edit().putString("LAST_VERSION_NAME", versionName).putInt("LAST_VERSION_CODE", versionCode).apply();
                return true;
            }
            return false;
        }
        return true;
    }

    public static PackageInfo getPackageInfo(Context context) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 16384);
        }
        catch (Exception ex) {
            ARouter.logger.error("ARouter::", "Get package info error.");
        }
        return packageInfo;
    }
}

