/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.android.arouter.core;

import android.content.Context;
import android.net.Uri;
import com.alibaba.android.arouter.core.Warehouse;
import com.alibaba.android.arouter.exception.HandlerException;
import com.alibaba.android.arouter.exception.NoRouteFoundException;
import com.alibaba.android.arouter.facade.Postcard;
import com.alibaba.android.arouter.facade.enums.TypeKind;
import com.alibaba.android.arouter.facade.model.RouteMeta;
import com.alibaba.android.arouter.facade.template.IInterceptorGroup;
import com.alibaba.android.arouter.facade.template.IProvider;
import com.alibaba.android.arouter.facade.template.IProviderGroup;
import com.alibaba.android.arouter.facade.template.IRouteGroup;
import com.alibaba.android.arouter.facade.template.IRouteRoot;
import com.alibaba.android.arouter.launcher.ARouter;
import com.alibaba.android.arouter.utils.ClassUtils;
import com.alibaba.android.arouter.utils.MapUtils;
import com.alibaba.android.arouter.utils.PackageUtils;
import com.alibaba.android.arouter.utils.TextUtils;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public class LogisticsCenter {
    private static Context mContext;
    static ThreadPoolExecutor executor;

    public static synchronized void init(Context context, ThreadPoolExecutor tpe) throws HandlerException {
        mContext = context;
        executor = tpe;
        try {
            Set<String> routerMap;
            long startInit = System.currentTimeMillis();
            if (ARouter.debuggable() || PackageUtils.isNewVersion(context)) {
                ARouter.logger.info("ARouter::", "Run with debug mode or new install, rebuild router map.");
                routerMap = ClassUtils.getFileNameByPackageName(mContext, "com.alibaba.android.arouter.routes");
                if (!routerMap.isEmpty()) {
                    context.getSharedPreferences("SP_AROUTER_CACHE", 0).edit().putStringSet("ROUTER_MAP", routerMap).apply();
                }
            } else {
                ARouter.logger.info("ARouter::", "Load router map from cache.");
                routerMap = new HashSet<String>(context.getSharedPreferences("SP_AROUTER_CACHE", 0).getStringSet("ROUTER_MAP", new HashSet()));
            }
            ARouter.logger.info("ARouter::", "Find router map finished, map size = " + routerMap.size() + ", cost " + (System.currentTimeMillis() - startInit) + " ms.");
            startInit = System.currentTimeMillis();
            for (String className : routerMap) {
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Root")) {
                    ((IRouteRoot)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.groupsIndex);
                    continue;
                }
                if (className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Interceptors")) {
                    ((IInterceptorGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.interceptorsIndex);
                    continue;
                }
                if (!className.startsWith("com.alibaba.android.arouter.routes.ARouter$$Providers")) continue;
                ((IProviderGroup)Class.forName(className).getConstructor(new Class[0]).newInstance(new Object[0])).loadInto(Warehouse.providersIndex);
            }
            ARouter.logger.info("ARouter::", "Load root element finished, cost " + (System.currentTimeMillis() - startInit) + " ms.");
            if (Warehouse.groupsIndex.size() == 0) {
                ARouter.logger.error("ARouter::", "No mapping files were found, check your configuration please!");
            }
            if (ARouter.debuggable()) {
                ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "LogisticsCenter has already been loaded, GroupIndex[%d], InterceptorIndex[%d], ProviderIndex[%d]", Warehouse.groupsIndex.size(), Warehouse.interceptorsIndex.size(), Warehouse.providersIndex.size()));
            }
        }
        catch (Exception e) {
            throw new HandlerException("ARouter::ARouter init logistics center exception! [" + e.getMessage() + "]");
        }
    }

    public static Postcard buildProvider(String serviceName) {
        RouteMeta meta = Warehouse.providersIndex.get(serviceName);
        if (null == meta) {
            return null;
        }
        return new Postcard(meta.getPath(), meta.getGroup());
    }

    public static synchronized void completion(Postcard postcard) {
        if (null == postcard) {
            throw new NoRouteFoundException("ARouter::No postcard!");
        }
        RouteMeta routeMeta = Warehouse.routes.get(postcard.getPath());
        if (null == routeMeta) {
            Class<? extends IRouteGroup> groupMeta = Warehouse.groupsIndex.get(postcard.getGroup());
            if (null == groupMeta) {
                throw new NoRouteFoundException("ARouter::There is no route match the path [" + postcard.getPath() + "], in group [" + postcard.getGroup() + "]");
            }
            try {
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] starts loading, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
                IRouteGroup iGroupInstance = groupMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                iGroupInstance.loadInto(Warehouse.routes);
                Warehouse.groupsIndex.remove(postcard.getGroup());
                if (ARouter.debuggable()) {
                    ARouter.logger.debug("ARouter::", String.format(Locale.getDefault(), "The group [%s] has already been loaded, trigger by [%s]", postcard.getGroup(), postcard.getPath()));
                }
            }
            catch (Exception e) {
                throw new HandlerException("ARouter::Fatal exception when loading group meta. [" + e.getMessage() + "]");
            }
            LogisticsCenter.completion(postcard);
        } else {
            postcard.setDestination(routeMeta.getDestination());
            postcard.setType(routeMeta.getType());
            postcard.setPriority(routeMeta.getPriority());
            postcard.setExtra(routeMeta.getExtra());
            Uri rawUri = postcard.getUri();
            if (null != rawUri) {
                Map<String, String> resultMap = TextUtils.splitQueryParameters(rawUri);
                Map paramsType = routeMeta.getParamsType();
                if (MapUtils.isNotEmpty(paramsType)) {
                    for (Map.Entry params : paramsType.entrySet()) {
                        LogisticsCenter.setValue(postcard, (Integer)params.getValue(), (String)params.getKey(), resultMap.get(params.getKey()));
                    }
                    postcard.getExtras().putStringArray("wmHzgD4lOj5o4241", paramsType.keySet().toArray(new String[0]));
                }
                postcard.withString("NTeRQWvye18AkPd6G", rawUri.toString());
            }
            switch (routeMeta.getType()) {
                case PROVIDER: {
                    Class providerMeta = routeMeta.getDestination();
                    IProvider instance = Warehouse.providers.get(providerMeta);
                    if (null == instance) {
                        try {
                            IProvider provider = (IProvider)providerMeta.getConstructor(new Class[0]).newInstance(new Object[0]);
                            provider.init(mContext);
                            Warehouse.providers.put(providerMeta, provider);
                            instance = provider;
                        }
                        catch (Exception e) {
                            throw new HandlerException("Init provider failed! " + e.getMessage());
                        }
                    }
                    postcard.setProvider(instance);
                    postcard.greenChannel();
                    break;
                }
                case FRAGMENT: {
                    postcard.greenChannel();
                }
            }
        }
    }

    private static void setValue(Postcard postcard, Integer typeDef, String key, String value) {
        if (TextUtils.isEmpty(key) || TextUtils.isEmpty(value)) {
            return;
        }
        try {
            if (null != typeDef) {
                if (typeDef.intValue() == TypeKind.BOOLEAN.ordinal()) {
                    postcard.withBoolean(key, Boolean.parseBoolean(value));
                } else if (typeDef.intValue() == TypeKind.BYTE.ordinal()) {
                    postcard.withByte(key, Byte.valueOf(value));
                } else if (typeDef.intValue() == TypeKind.SHORT.ordinal()) {
                    postcard.withShort(key, Short.valueOf(value));
                } else if (typeDef.intValue() == TypeKind.INT.ordinal()) {
                    postcard.withInt(key, Integer.valueOf(value));
                } else if (typeDef.intValue() == TypeKind.LONG.ordinal()) {
                    postcard.withLong(key, Long.valueOf(value));
                } else if (typeDef.intValue() == TypeKind.FLOAT.ordinal()) {
                    postcard.withFloat(key, Float.valueOf(value).floatValue());
                } else if (typeDef.intValue() == TypeKind.DOUBLE.ordinal()) {
                    postcard.withDouble(key, Double.valueOf(value));
                } else if (typeDef.intValue() == TypeKind.STRING.ordinal()) {
                    postcard.withString(key, value);
                } else if (typeDef.intValue() != TypeKind.PARCELABLE.ordinal()) {
                    if (typeDef.intValue() == TypeKind.OBJECT.ordinal()) {
                        postcard.withString(key, value);
                    } else {
                        postcard.withString(key, value);
                    }
                }
            } else {
                postcard.withString(key, value);
            }
        }
        catch (Throwable ex) {
            ARouter.logger.warning("ARouter::", "LogisticsCenter setValue failed! " + ex.getMessage());
        }
    }

    public static void suspend() {
        Warehouse.clear();
    }
}

