/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TriggerNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTriggersResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListTriggersResponse> {
    private static final SdkField<List<String>> TRIGGER_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TriggerNames").getter(ListTriggersResponse.getter(ListTriggersResponse::triggerNames)).setter(ListTriggersResponse.setter(Builder::triggerNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTriggersResponse.getter(ListTriggersResponse::nextToken)).setter(ListTriggersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIGGER_NAMES_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> triggerNames;
    private final String nextToken;

    private ListTriggersResponse(BuilderImpl builder) {
        super(builder);
        this.triggerNames = builder.triggerNames;
        this.nextToken = builder.nextToken;
    }

    public boolean hasTriggerNames() {
        return this.triggerNames != null && !(this.triggerNames instanceof SdkAutoConstructList);
    }

    public List<String> triggerNames() {
        return this.triggerNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.triggerNames());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTriggersResponse)) {
            return false;
        }
        ListTriggersResponse other = (ListTriggersResponse)((Object)obj);
        return Objects.equals(this.triggerNames(), other.triggerNames()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListTriggersResponse").add("TriggerNames", this.triggerNames()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TriggerNames": {
                return Optional.ofNullable(clazz.cast(this.triggerNames()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTriggersResponse, T> g) {
        return obj -> g.apply((ListTriggersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private List<String> triggerNames = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTriggersResponse model) {
            super(model);
            this.triggerNames(model.triggerNames);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getTriggerNames() {
            return this.triggerNames;
        }

        @Override
        public final Builder triggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggerNames(String ... triggerNames) {
            this.triggerNames(Arrays.asList(triggerNames));
            return this;
        }

        public final void setTriggerNames(Collection<String> triggerNames) {
            this.triggerNames = TriggerNameListCopier.copy(triggerNames);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTriggersResponse build() {
            return new ListTriggersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTriggersResponse> {
        public Builder triggerNames(Collection<String> var1);

        public Builder triggerNames(String ... var1);

        public Builder nextToken(String var1);
    }
}

