/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrawlerMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrawlerMetrics> {
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerName").getter(CrawlerMetrics.getter(CrawlerMetrics::crawlerName)).setter(CrawlerMetrics.setter(Builder::crawlerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()}).build();
    private static final SdkField<Double> TIME_LEFT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("TimeLeftSeconds").getter(CrawlerMetrics.getter(CrawlerMetrics::timeLeftSeconds)).setter(CrawlerMetrics.setter(Builder::timeLeftSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeLeftSeconds").build()}).build();
    private static final SdkField<Boolean> STILL_ESTIMATING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StillEstimating").getter(CrawlerMetrics.getter(CrawlerMetrics::stillEstimating)).setter(CrawlerMetrics.setter(Builder::stillEstimating)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StillEstimating").build()}).build();
    private static final SdkField<Double> LAST_RUNTIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("LastRuntimeSeconds").getter(CrawlerMetrics.getter(CrawlerMetrics::lastRuntimeSeconds)).setter(CrawlerMetrics.setter(Builder::lastRuntimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRuntimeSeconds").build()}).build();
    private static final SdkField<Double> MEDIAN_RUNTIME_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("MedianRuntimeSeconds").getter(CrawlerMetrics.getter(CrawlerMetrics::medianRuntimeSeconds)).setter(CrawlerMetrics.setter(Builder::medianRuntimeSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MedianRuntimeSeconds").build()}).build();
    private static final SdkField<Integer> TABLES_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesCreated").getter(CrawlerMetrics.getter(CrawlerMetrics::tablesCreated)).setter(CrawlerMetrics.setter(Builder::tablesCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesCreated").build()}).build();
    private static final SdkField<Integer> TABLES_UPDATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesUpdated").getter(CrawlerMetrics.getter(CrawlerMetrics::tablesUpdated)).setter(CrawlerMetrics.setter(Builder::tablesUpdated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesUpdated").build()}).build();
    private static final SdkField<Integer> TABLES_DELETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TablesDeleted").getter(CrawlerMetrics.getter(CrawlerMetrics::tablesDeleted)).setter(CrawlerMetrics.setter(Builder::tablesDeleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TablesDeleted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_NAME_FIELD, TIME_LEFT_SECONDS_FIELD, STILL_ESTIMATING_FIELD, LAST_RUNTIME_SECONDS_FIELD, MEDIAN_RUNTIME_SECONDS_FIELD, TABLES_CREATED_FIELD, TABLES_UPDATED_FIELD, TABLES_DELETED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String crawlerName;
    private final Double timeLeftSeconds;
    private final Boolean stillEstimating;
    private final Double lastRuntimeSeconds;
    private final Double medianRuntimeSeconds;
    private final Integer tablesCreated;
    private final Integer tablesUpdated;
    private final Integer tablesDeleted;

    private CrawlerMetrics(BuilderImpl builder) {
        this.crawlerName = builder.crawlerName;
        this.timeLeftSeconds = builder.timeLeftSeconds;
        this.stillEstimating = builder.stillEstimating;
        this.lastRuntimeSeconds = builder.lastRuntimeSeconds;
        this.medianRuntimeSeconds = builder.medianRuntimeSeconds;
        this.tablesCreated = builder.tablesCreated;
        this.tablesUpdated = builder.tablesUpdated;
        this.tablesDeleted = builder.tablesDeleted;
    }

    public String crawlerName() {
        return this.crawlerName;
    }

    public Double timeLeftSeconds() {
        return this.timeLeftSeconds;
    }

    public Boolean stillEstimating() {
        return this.stillEstimating;
    }

    public Double lastRuntimeSeconds() {
        return this.lastRuntimeSeconds;
    }

    public Double medianRuntimeSeconds() {
        return this.medianRuntimeSeconds;
    }

    public Integer tablesCreated() {
        return this.tablesCreated;
    }

    public Integer tablesUpdated() {
        return this.tablesUpdated;
    }

    public Integer tablesDeleted() {
        return this.tablesDeleted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeLeftSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.stillEstimating());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRuntimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.medianRuntimeSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(this.tablesDeleted());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrawlerMetrics)) {
            return false;
        }
        CrawlerMetrics other = (CrawlerMetrics)obj;
        return Objects.equals(this.crawlerName(), other.crawlerName()) && Objects.equals(this.timeLeftSeconds(), other.timeLeftSeconds()) && Objects.equals(this.stillEstimating(), other.stillEstimating()) && Objects.equals(this.lastRuntimeSeconds(), other.lastRuntimeSeconds()) && Objects.equals(this.medianRuntimeSeconds(), other.medianRuntimeSeconds()) && Objects.equals(this.tablesCreated(), other.tablesCreated()) && Objects.equals(this.tablesUpdated(), other.tablesUpdated()) && Objects.equals(this.tablesDeleted(), other.tablesDeleted());
    }

    public String toString() {
        return ToString.builder((String)"CrawlerMetrics").add("CrawlerName", (Object)this.crawlerName()).add("TimeLeftSeconds", (Object)this.timeLeftSeconds()).add("StillEstimating", (Object)this.stillEstimating()).add("LastRuntimeSeconds", (Object)this.lastRuntimeSeconds()).add("MedianRuntimeSeconds", (Object)this.medianRuntimeSeconds()).add("TablesCreated", (Object)this.tablesCreated()).add("TablesUpdated", (Object)this.tablesUpdated()).add("TablesDeleted", (Object)this.tablesDeleted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CrawlerName": {
                return Optional.ofNullable(clazz.cast(this.crawlerName()));
            }
            case "TimeLeftSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeLeftSeconds()));
            }
            case "StillEstimating": {
                return Optional.ofNullable(clazz.cast(this.stillEstimating()));
            }
            case "LastRuntimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.lastRuntimeSeconds()));
            }
            case "MedianRuntimeSeconds": {
                return Optional.ofNullable(clazz.cast(this.medianRuntimeSeconds()));
            }
            case "TablesCreated": {
                return Optional.ofNullable(clazz.cast(this.tablesCreated()));
            }
            case "TablesUpdated": {
                return Optional.ofNullable(clazz.cast(this.tablesUpdated()));
            }
            case "TablesDeleted": {
                return Optional.ofNullable(clazz.cast(this.tablesDeleted()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrawlerMetrics, T> g) {
        return obj -> g.apply((CrawlerMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String crawlerName;
        private Double timeLeftSeconds;
        private Boolean stillEstimating;
        private Double lastRuntimeSeconds;
        private Double medianRuntimeSeconds;
        private Integer tablesCreated;
        private Integer tablesUpdated;
        private Integer tablesDeleted;

        private BuilderImpl() {
        }

        private BuilderImpl(CrawlerMetrics model) {
            this.crawlerName(model.crawlerName);
            this.timeLeftSeconds(model.timeLeftSeconds);
            this.stillEstimating(model.stillEstimating);
            this.lastRuntimeSeconds(model.lastRuntimeSeconds);
            this.medianRuntimeSeconds(model.medianRuntimeSeconds);
            this.tablesCreated(model.tablesCreated);
            this.tablesUpdated(model.tablesUpdated);
            this.tablesDeleted(model.tablesDeleted);
        }

        public final String getCrawlerName() {
            return this.crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        public final Double getTimeLeftSeconds() {
            return this.timeLeftSeconds;
        }

        @Override
        public final Builder timeLeftSeconds(Double timeLeftSeconds) {
            this.timeLeftSeconds = timeLeftSeconds;
            return this;
        }

        public final void setTimeLeftSeconds(Double timeLeftSeconds) {
            this.timeLeftSeconds = timeLeftSeconds;
        }

        public final Boolean getStillEstimating() {
            return this.stillEstimating;
        }

        @Override
        public final Builder stillEstimating(Boolean stillEstimating) {
            this.stillEstimating = stillEstimating;
            return this;
        }

        public final void setStillEstimating(Boolean stillEstimating) {
            this.stillEstimating = stillEstimating;
        }

        public final Double getLastRuntimeSeconds() {
            return this.lastRuntimeSeconds;
        }

        @Override
        public final Builder lastRuntimeSeconds(Double lastRuntimeSeconds) {
            this.lastRuntimeSeconds = lastRuntimeSeconds;
            return this;
        }

        public final void setLastRuntimeSeconds(Double lastRuntimeSeconds) {
            this.lastRuntimeSeconds = lastRuntimeSeconds;
        }

        public final Double getMedianRuntimeSeconds() {
            return this.medianRuntimeSeconds;
        }

        @Override
        public final Builder medianRuntimeSeconds(Double medianRuntimeSeconds) {
            this.medianRuntimeSeconds = medianRuntimeSeconds;
            return this;
        }

        public final void setMedianRuntimeSeconds(Double medianRuntimeSeconds) {
            this.medianRuntimeSeconds = medianRuntimeSeconds;
        }

        public final Integer getTablesCreated() {
            return this.tablesCreated;
        }

        @Override
        public final Builder tablesCreated(Integer tablesCreated) {
            this.tablesCreated = tablesCreated;
            return this;
        }

        public final void setTablesCreated(Integer tablesCreated) {
            this.tablesCreated = tablesCreated;
        }

        public final Integer getTablesUpdated() {
            return this.tablesUpdated;
        }

        @Override
        public final Builder tablesUpdated(Integer tablesUpdated) {
            this.tablesUpdated = tablesUpdated;
            return this;
        }

        public final void setTablesUpdated(Integer tablesUpdated) {
            this.tablesUpdated = tablesUpdated;
        }

        public final Integer getTablesDeleted() {
            return this.tablesDeleted;
        }

        @Override
        public final Builder tablesDeleted(Integer tablesDeleted) {
            this.tablesDeleted = tablesDeleted;
            return this;
        }

        public final void setTablesDeleted(Integer tablesDeleted) {
            this.tablesDeleted = tablesDeleted;
        }

        public CrawlerMetrics build() {
            return new CrawlerMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrawlerMetrics> {
        public Builder crawlerName(String var1);

        public Builder timeLeftSeconds(Double var1);

        public Builder stillEstimating(Boolean var1);

        public Builder lastRuntimeSeconds(Double var1);

        public Builder medianRuntimeSeconds(Double var1);

        public Builder tablesCreated(Integer var1);

        public Builder tablesUpdated(Integer var1);

        public Builder tablesDeleted(Integer var1);
    }
}

