/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.media.IAudioService;
import android.media.SoundPool;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=SoundPool.class)
public class ShadowSoundPool {
    @RealObject
    SoundPool realObject;
    private final AtomicInteger soundIds = new AtomicInteger(1);
    private final SparseArray<String> idToPaths = new SparseArray();
    private final SparseIntArray idToRes = new SparseIntArray();
    private final List<Playback> playedSounds = new ArrayList<Playback>();
    private SoundPool.OnLoadCompleteListener listener;

    @Implementation(minSdk=24, maxSdk=25)
    protected static IAudioService getService() {
        return (IAudioService)ReflectionHelpers.createNullProxy(IAudioService.class);
    }

    @Implementation(maxSdk=22)
    protected int play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        this.playedSounds.add(new Playback(soundID, leftVolume, rightVolume, priority, loop, rate));
        return 1;
    }

    @Implementation(minSdk=23)
    protected int _play(int soundID, float leftVolume, float rightVolume, int priority, int loop, float rate) {
        this.playedSounds.add(new Playback(soundID, leftVolume, rightVolume, priority, loop, rate));
        return 1;
    }

    @Implementation
    protected int load(String path, int priority) {
        int soundId = this.soundIds.getAndIncrement();
        this.idToPaths.put(soundId, (Object)path);
        return soundId;
    }

    @Implementation
    protected int load(Context context, int resId, int priority) {
        int soundId = this.soundIds.getAndIncrement();
        this.idToRes.put(soundId, resId);
        return soundId;
    }

    @Implementation
    protected void setOnLoadCompleteListener(SoundPool.OnLoadCompleteListener listener) {
        this.listener = listener;
    }

    public void notifyPathLoaded(String path, boolean success) {
        boolean soundIsKnown = false;
        for (int pathIdx = 0; pathIdx < this.idToPaths.size(); ++pathIdx) {
            if (!((String)this.idToPaths.valueAt(pathIdx)).equals(path)) continue;
            if (this.listener != null) {
                this.listener.onLoadComplete(this.realObject, this.idToPaths.keyAt(pathIdx), success ? 0 : 1);
            }
            soundIsKnown = true;
        }
        if (!soundIsKnown) {
            throw new IllegalArgumentException("Unknown sound. You need to call load() first");
        }
    }

    public void notifyResourceLoaded(int resId, boolean success) {
        boolean soundIsKnown = false;
        for (int resIdx = 0; resIdx < this.idToRes.size(); ++resIdx) {
            if (this.idToRes.valueAt(resIdx) != resId) continue;
            if (this.listener != null) {
                this.listener.onLoadComplete(this.realObject, this.idToRes.keyAt(resIdx), success ? 0 : 1);
            }
            soundIsKnown = true;
        }
        if (!soundIsKnown) {
            throw new IllegalArgumentException("Unknown sound. You need to call load() first");
        }
    }

    public boolean wasPathPlayed(String path) {
        for (Playback playback : this.playedSounds) {
            if (!this.idIsForPath(playback.soundId, path)) continue;
            return true;
        }
        return false;
    }

    public boolean wasResourcePlayed(int resId) {
        for (Playback playback : this.playedSounds) {
            if (!this.idIsForResource(playback.soundId, resId)) continue;
            return true;
        }
        return false;
    }

    public List<Playback> getPathPlaybacks(String path) {
        ImmutableList.Builder playbacks = ImmutableList.builder();
        for (Playback playback : this.playedSounds) {
            if (!this.idIsForPath(playback.soundId, path)) continue;
            playbacks.add((Object)playback);
        }
        return playbacks.build();
    }

    public List<Playback> getResourcePlaybacks(int resId) {
        ImmutableList.Builder playbacks = ImmutableList.builder();
        for (Playback playback : this.playedSounds) {
            if (!this.idIsForResource(playback.soundId, resId)) continue;
            playbacks.add((Object)playback);
        }
        return playbacks.build();
    }

    private boolean idIsForPath(int soundId, String path) {
        return this.idToPaths.indexOfKey(soundId) >= 0 && ((String)this.idToPaths.get(soundId)).equals(path);
    }

    private boolean idIsForResource(int soundId, int resId) {
        return this.idToRes.indexOfKey(soundId) >= 0 && this.idToRes.get(soundId) == resId;
    }

    public void clearPlayed() {
        this.playedSounds.clear();
    }

    public static final class Playback {
        public final int soundId;
        public final float leftVolume;
        public final float rightVolume;
        public final int priority;
        public final int loop;
        public final float rate;

        public Playback(int soundId, float leftVolume, float rightVolume, int priority, int loop, float rate) {
            this.soundId = soundId;
            this.leftVolume = leftVolume;
            this.rightVolume = rightVolume;
            this.priority = priority;
            this.loop = loop;
            this.rate = rate;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Playback)) {
                return false;
            }
            Playback that = (Playback)o;
            return this.soundId == that.soundId && this.leftVolume == that.leftVolume && this.rightVolume == that.rightVolume && this.priority == that.priority && this.loop == that.loop && this.rate == that.rate;
        }

        public int hashCode() {
            return Objects.hash(this.soundId, Float.valueOf(this.leftVolume), Float.valueOf(this.rightVolume), this.priority, this.loop, Float.valueOf(this.rate));
        }

        public String toString() {
            return Arrays.asList(this.soundId, Float.valueOf(this.leftVolume), Float.valueOf(this.rightVolume), this.priority, this.loop, Float.valueOf(this.rate)).toString();
        }
    }
}

