/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ShortcutInfo;
import android.content.pm.ShortcutManager;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ShortcutManager.class, minSdk=25)
public class ShadowShortcutManager {
    private static final int MAX_ICON_DIMENSION = 128;
    private final Map<String, ShortcutInfo> dynamicShortcuts = new HashMap<String, ShortcutInfo>();
    private final Map<String, ShortcutInfo> activePinnedShortcuts = new HashMap<String, ShortcutInfo>();
    private final Map<String, ShortcutInfo> disabledPinnedShortcuts = new HashMap<String, ShortcutInfo>();
    private List<ShortcutInfo> manifestShortcuts = ImmutableList.of();
    private boolean isRequestPinShortcutSupported = true;
    private int maxShortcutCountPerActivity = 16;
    private int maxIconHeight = 128;
    private int maxIconWidth = 128;

    @Implementation
    protected boolean addDynamicShortcuts(List<ShortcutInfo> shortcutInfoList) {
        for (ShortcutInfo shortcutInfo : shortcutInfoList) {
            ShortcutInfo previousShortcut;
            shortcutInfo.addFlags(1);
            if (this.activePinnedShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.activePinnedShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.activePinnedShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            if (this.disabledPinnedShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.disabledPinnedShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.disabledPinnedShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            if (this.dynamicShortcuts.containsKey(shortcutInfo.getId())) {
                previousShortcut = this.dynamicShortcuts.get(shortcutInfo.getId());
                if (previousShortcut.isImmutable()) continue;
                this.dynamicShortcuts.put(shortcutInfo.getId(), shortcutInfo);
                continue;
            }
            this.dynamicShortcuts.put(shortcutInfo.getId(), shortcutInfo);
        }
        return true;
    }

    @Implementation(minSdk=26)
    protected Intent createShortcutResultIntent(ShortcutInfo shortcut) {
        if (this.disabledPinnedShortcuts.containsKey(shortcut.getId())) {
            throw new IllegalArgumentException();
        }
        return new Intent();
    }

    @Implementation
    protected void disableShortcuts(List<String> shortcutIds) {
        this.disableShortcuts(shortcutIds, "Shortcut is disabled.");
    }

    @Implementation
    protected void disableShortcuts(List<String> shortcutIds, CharSequence unused) {
        for (String shortcutId : shortcutIds) {
            ShortcutInfo shortcut = this.activePinnedShortcuts.remove(shortcutId);
            if (shortcut == null) continue;
            this.disabledPinnedShortcuts.put(shortcutId, shortcut);
        }
    }

    @Implementation
    protected void enableShortcuts(List<String> shortcutIds) {
        for (String shortcutId : shortcutIds) {
            ShortcutInfo shortcut = this.disabledPinnedShortcuts.remove(shortcutId);
            if (shortcut == null) continue;
            this.activePinnedShortcuts.put(shortcutId, shortcut);
        }
    }

    @Implementation
    protected List<ShortcutInfo> getDynamicShortcuts() {
        return ImmutableList.copyOf(this.dynamicShortcuts.values());
    }

    @Implementation
    protected int getIconMaxHeight() {
        return this.maxIconHeight;
    }

    @Implementation
    protected int getIconMaxWidth() {
        return this.maxIconWidth;
    }

    public void setIconMaxHeight(int height) {
        this.maxIconHeight = height;
    }

    public void setIconMaxWidth(int width) {
        this.maxIconWidth = width;
    }

    @Implementation
    protected List<ShortcutInfo> getManifestShortcuts() {
        return this.manifestShortcuts;
    }

    public void setManifestShortcuts(List<ShortcutInfo> manifestShortcuts) {
        for (ShortcutInfo shortcutInfo : manifestShortcuts) {
            shortcutInfo.addFlags(32);
        }
        this.manifestShortcuts = manifestShortcuts;
    }

    @Implementation
    protected int getMaxShortcutCountPerActivity() {
        return this.maxShortcutCountPerActivity;
    }

    public void setMaxShortcutCountPerActivity(int value) {
        this.maxShortcutCountPerActivity = value;
    }

    @Implementation
    protected List<ShortcutInfo> getPinnedShortcuts() {
        ImmutableList.Builder pinnedShortcuts = ImmutableList.builder();
        pinnedShortcuts.addAll(this.activePinnedShortcuts.values());
        pinnedShortcuts.addAll(this.disabledPinnedShortcuts.values());
        return pinnedShortcuts.build();
    }

    @Implementation
    protected boolean isRateLimitingActive() {
        return false;
    }

    @Implementation(minSdk=26)
    protected boolean isRequestPinShortcutSupported() {
        return this.isRequestPinShortcutSupported;
    }

    public void setIsRequestPinShortcutSupported(boolean isRequestPinShortcutSupported) {
        this.isRequestPinShortcutSupported = isRequestPinShortcutSupported;
    }

    @Implementation
    protected void removeAllDynamicShortcuts() {
        this.dynamicShortcuts.clear();
    }

    @Implementation
    protected void removeDynamicShortcuts(List<String> shortcutIds) {
        for (String shortcutId : shortcutIds) {
            this.dynamicShortcuts.remove(shortcutId);
        }
    }

    @Implementation
    protected void reportShortcutUsed(String shortcutId) {
    }

    @Implementation(minSdk=26)
    protected boolean requestPinShortcut(ShortcutInfo shortcut, IntentSender resultIntent) {
        shortcut.addFlags(2);
        if (this.disabledPinnedShortcuts.containsKey(shortcut.getId())) {
            String string2 = shortcut.getId();
            throw new IllegalArgumentException(new StringBuilder(51 + String.valueOf(string2).length()).append("Shortcut with ID [").append(string2).append("] already exists and is disabled.").toString());
        }
        if (this.dynamicShortcuts.containsKey(shortcut.getId())) {
            this.activePinnedShortcuts.put(shortcut.getId(), this.dynamicShortcuts.remove(shortcut.getId()));
        } else {
            this.activePinnedShortcuts.put(shortcut.getId(), shortcut);
        }
        if (resultIntent != null) {
            try {
                resultIntent.sendIntent((Context)RuntimeEnvironment.getApplication(), 0, null, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                throw new IllegalStateException();
            }
        }
        return true;
    }

    @Implementation
    protected boolean setDynamicShortcuts(List<ShortcutInfo> shortcutInfoList) {
        this.dynamicShortcuts.clear();
        return this.addDynamicShortcuts(shortcutInfoList);
    }

    @Implementation
    protected boolean updateShortcuts(List<ShortcutInfo> shortcutInfoList) {
        ArrayList<ShortcutInfo> existingShortcutsToUpdate = new ArrayList<ShortcutInfo>();
        for (ShortcutInfo shortcutInfo : shortcutInfoList) {
            if (!this.dynamicShortcuts.containsKey(shortcutInfo.getId()) && !this.activePinnedShortcuts.containsKey(shortcutInfo.getId()) && !this.disabledPinnedShortcuts.containsKey(shortcutInfo.getId())) continue;
            existingShortcutsToUpdate.add(shortcutInfo);
        }
        return this.addDynamicShortcuts(existingShortcutsToUpdate);
    }

    protected void updateShortcutVisibility(String packageName, byte[] certificate, boolean visible) {
    }

    @Implementation(minSdk=30)
    protected List<ShortcutInfo> getShortcuts(int matchFlags) {
        if (matchFlags == 0) {
            return Lists.newArrayList();
        }
        HashSet<ShortcutInfo> shortcutInfoSet = new HashSet<ShortcutInfo>();
        shortcutInfoSet.addAll(this.getManifestShortcuts());
        shortcutInfoSet.addAll(this.getDynamicShortcuts());
        shortcutInfoSet.addAll(this.getPinnedShortcuts());
        return shortcutInfoSet.stream().filter(shortcutInfo -> (matchFlags & 1) != 0 && shortcutInfo.isDeclaredInManifest() || (matchFlags & 2) != 0 && shortcutInfo.isDynamic() || (matchFlags & 4) != 0 && shortcutInfo.isPinned() || (matchFlags & 8) != 0 && (shortcutInfo.isCached() || shortcutInfo.isLongLived())).collect(Collectors.toCollection(ArrayList::new));
    }

    @Implementation(minSdk=30)
    protected void pushDynamicShortcut(ShortcutInfo shortcut) {
        this.addDynamicShortcuts(Arrays.asList(shortcut));
    }

    @Implementation(minSdk=30)
    protected void removeLongLivedShortcuts(List<String> shortcutIds) {
    }
}

