/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.widget.PopupMenu;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=PopupMenu.class)
public class ShadowPopupMenu {
    @RealObject
    private PopupMenu realPopupMenu;
    private boolean isShowing;
    private PopupMenu.OnMenuItemClickListener onMenuItemClickListener;

    @Implementation
    protected void show() {
        this.isShowing = true;
        ShadowPopupMenu.setLatestPopupMenu(this);
        ((PopupMenuReflector)Reflector.reflector(PopupMenuReflector.class, (Object)this.realPopupMenu)).show();
    }

    @Implementation
    protected void dismiss() {
        this.isShowing = false;
        ((PopupMenuReflector)Reflector.reflector(PopupMenuReflector.class, (Object)this.realPopupMenu)).dismiss();
    }

    @Implementation
    protected void setOnMenuItemClickListener(PopupMenu.OnMenuItemClickListener listener) {
        this.onMenuItemClickListener = listener;
        ((PopupMenuReflector)Reflector.reflector(PopupMenuReflector.class, (Object)this.realPopupMenu)).setOnMenuItemClickListener(listener);
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    public static PopupMenu getLatestPopupMenu() {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        ShadowPopupMenu popupMenu = shadowApplication.getLatestPopupMenu();
        return popupMenu == null ? null : popupMenu.realPopupMenu;
    }

    public static void setLatestPopupMenu(ShadowPopupMenu latestPopupMenu) {
        ShadowApplication shadowApplication = (ShadowApplication)Shadow.extract((Object)RuntimeEnvironment.getApplication());
        if (shadowApplication != null) {
            shadowApplication.setLatestPopupMenu(latestPopupMenu);
        }
    }

    public PopupMenu.OnMenuItemClickListener getOnMenuItemClickListener() {
        return this.onMenuItemClickListener;
    }

    @ForType(value=PopupMenu.class)
    static interface PopupMenuReflector {
        @Direct
        public void show();

        @Direct
        public void dismiss();

        @Direct
        public void setOnMenuItemClickListener(PopupMenu.OnMenuItemClickListener var1);
    }
}

