/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.Choreographer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.LooperMode;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadows.LooperShadowPicker;
import org.robolectric.shadows.ShadowDisplayEventReceiver;
import org.robolectric.shadows.ShadowLegacyChoreographer;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.shadows.ShadowPausedChoreographer;
import org.robolectric.util.PerfStatsCollector;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=Choreographer.class, shadowPicker=Picker.class)
public abstract class ShadowChoreographer {
    @RealObject
    Choreographer realObject;
    private ChoreographerReflector reflector;

    public static void setPostCallbackDelay(int delayMillis) {
        ShadowLegacyChoreographer.setPostCallbackDelay(delayMillis);
    }

    public static void setPostFrameCallbackDelay(int delayMillis) {
        if (ShadowLooper.looperMode() == LooperMode.Mode.PAUSED) {
            ShadowDisplayEventReceiver.setAsyncVsync(delayMillis);
        } else {
            ShadowLegacyChoreographer.setPostFrameCallbackDelay(delayMillis);
        }
    }

    public static long getFrameInterval() {
        return ShadowLegacyChoreographer.getFrameInterval();
    }

    public static void setFrameInterval(long frameInterval) {
        ShadowLegacyChoreographer.setFrameInterval(frameInterval);
    }

    @Implementation(maxSdk=30)
    protected void doFrame(long frameTimeNanos, int frame) {
        if (this.reflector == null) {
            this.reflector = (ChoreographerReflector)Reflector.reflector(ChoreographerReflector.class, (Object)this.realObject);
        }
        PerfStatsCollector.getInstance().measure("doFrame", () -> this.reflector.doFrame(frameTimeNanos, frame));
    }

    @ForType(value=Choreographer.class)
    protected static interface ChoreographerReflector {
        @Accessor(value="sThreadInstance")
        @Static
        public ThreadLocal<Choreographer> getThreadInstance();

        @Direct
        public void doFrame(long var1, int var3);
    }

    public static class Picker
    extends LooperShadowPicker<ShadowChoreographer> {
        public Picker() {
            super(ShadowLegacyChoreographer.class, ShadowPausedChoreographer.class);
        }
    }
}

