/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.android.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.robolectric.android.util.concurrent.InlineExecutorService;
import org.robolectric.android.util.concurrent.PausedExecutorService;

public class BackgroundExecutor {
    private final InlineExecutorService backgroundExecutorService = new InlineExecutorService();

    private BackgroundExecutor() {
    }

    public static void runInBackground(Runnable runnable) {
        SingletonHolder.instance.backgroundExecutorService.execute(runnable);
    }

    public static <T> T runInBackground(Callable<T> callable) {
        Future<T> future = SingletonHolder.instance.backgroundExecutorService.submit(callable);
        return PausedExecutorService.getFutureResultWithExceptionPreserved(future);
    }

    private static class SingletonHolder {
        private static final BackgroundExecutor instance = new BackgroundExecutor();

        private SingletonHolder() {
        }
    }
}

