/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.internal.dependency;

public class DependencyJar {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final String classifier;

    public DependencyJar(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public DependencyJar(String groupId, String artifactId, String version, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return "jar";
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getShortName() {
        String string;
        String string2 = this.getGroupId();
        String string3 = this.getArtifactId();
        String string4 = this.getVersion();
        if (this.getClassifier() == null) {
            string = "";
        } else {
            String string5 = String.valueOf(this.getClassifier());
            string = string5.length() != 0 ? ":".concat(string5) : new String(":");
        }
        String string6 = string;
        return new StringBuilder(2 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string6).length()).append(string2).append(":").append(string3).append(":").append(string4).append(string6).toString();
    }

    public String toString() {
        String string = this.getShortName();
        return new StringBuilder(15 + String.valueOf(string).length()).append("DependencyJar{").append(string).append('}').toString();
    }
}

