/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import org.apache.tuweni.units.bigints.UInt64;

public final class UInt64Domain
extends DiscreteDomain<UInt64> {
    public UInt64 next(UInt64 value) {
        return value.add(1L);
    }

    public UInt64 previous(UInt64 value) {
        return value.subtract(1L);
    }

    public long distance(UInt64 start, UInt64 end) {
        UInt64 distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        UInt64 uInt64 = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public UInt64 minValue() {
        return UInt64.MIN_VALUE;
    }

    public UInt64 maxValue() {
        return UInt64.MAX_VALUE;
    }
}

