/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import com.google.common.collect.DiscreteDomain;
import java.util.function.Function;
import org.apache.tuweni.units.bigints.UInt32;
import org.apache.tuweni.units.bigints.UInt32Value;

public final class UInt32ValueDomain<T extends UInt32Value<T>>
extends DiscreteDomain<T> {
    private final T minValue;
    private final T maxValue;

    public UInt32ValueDomain(Function<UInt32, T> ctor) {
        this.minValue = (UInt32Value)ctor.apply(UInt32.MIN_VALUE);
        this.maxValue = (UInt32Value)ctor.apply(UInt32.MAX_VALUE);
    }

    public T next(T value) {
        return value.add(1);
    }

    public T previous(T value) {
        return value.subtract(1);
    }

    public long distance(T start, T end) {
        T distance;
        boolean negativeDistance = start.compareTo(end) < 0;
        T t = distance = negativeDistance ? end.subtract(start) : start.subtract(end);
        if (!distance.fitsLong()) {
            return negativeDistance ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        long distanceLong = distance.toLong();
        return negativeDistance ? -distanceLong : distanceLong;
    }

    public T minValue() {
        return this.minValue;
    }

    public T maxValue() {
        return this.maxValue;
    }
}

