/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto.sodium;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import javax.security.auth.Destroyable;
import jnr.ffi.Pointer;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.crypto.sodium.Sodium;

public final class Allocated
implements Destroyable {
    @Nullable
    private Pointer ptr;
    private final int length;

    public static Allocated fromBytes(Bytes bytes) {
        Allocated allocated = Allocated.allocate(bytes.size());
        allocated.pointer().put(0L, bytes.toArrayUnsafe(), 0, bytes.size());
        return allocated;
    }

    static Allocated allocate(long length) {
        Pointer ptr = Sodium.malloc(length);
        return new Allocated(ptr, (int)length);
    }

    Allocated(Pointer ptr, int length) {
        this.ptr = ptr;
        this.length = length;
    }

    Pointer pointer() {
        if (this.isDestroyed()) {
            throw new IllegalArgumentException("SecretKey has been destroyed");
        }
        return this.ptr;
    }

    int length() {
        return this.length;
    }

    @Override
    public void destroy() {
        if (!this.isDestroyed()) {
            Pointer p = this.ptr;
            this.ptr = null;
            Sodium.sodium_free(p);
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.ptr == null;
    }

    public Bytes bytes() {
        return Bytes.wrap((byte[])this.bytesArray());
    }

    public byte[] bytesArray() {
        Preconditions.checkState((!this.isDestroyed() ? 1 : 0) != 0, (Object)"allocated value has been destroyed");
        return Sodium.reify(this.ptr, this.length);
    }

    protected void finalize() {
        Sodium.sodium_free(this.ptr);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Allocated)) {
            return false;
        }
        Allocated other = (Allocated)obj;
        Preconditions.checkState((!this.isDestroyed() ? 1 : 0) != 0, (Object)"allocated value has been destroyed");
        Preconditions.checkState((!other.isDestroyed() ? 1 : 0) != 0, (Object)"allocated value has been destroyed");
        return Sodium.sodium_memcmp(this.ptr, other.ptr, this.length) == 0;
    }

    public int hashCode() {
        Preconditions.checkState((!this.isDestroyed() ? 1 : 0) != 0, (Object)"allocated value has been destroyed");
        return Sodium.hashCode(this.ptr, this.length);
    }
}

