/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;

public final class Hash {
    private static String SHA2_256 = "SHA-256";
    private static String SHA2_512_256 = "SHA-512/256";
    private static String KECCAK_256 = "KECCAK-256";
    private static String KECCAK_512 = "KECCAK-512";
    private static String SHA3_256 = "SHA3-256";
    private static String SHA3_512 = "SHA3-512";

    private Hash() {
    }

    public static byte[] digestUsingAlgorithm(byte[] input, String alg) throws NoSuchAlgorithmException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(alg);
        MessageDigest digest = MessageDigest.getInstance(alg);
        digest.update(input);
        return digest.digest();
    }

    public static Bytes digestUsingAlgorithm(Bytes input, String alg) throws NoSuchAlgorithmException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(alg);
        MessageDigest digest = MessageDigest.getInstance(alg);
        input.update(digest);
        return Bytes.wrap((byte[])digest.digest());
    }

    public static byte[] sha2_256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA2_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 sha2_256(Bytes input) {
        try {
            return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, SHA2_256).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha2_512_256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA2_512_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 sha2_512_256(Bytes input) {
        try {
            return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, SHA2_512_256).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] keccak256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, KECCAK_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 keccak256(Bytes input) {
        try {
            return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, KECCAK_256).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] keccak512(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, KECCAK_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes keccak512(Bytes input) {
        try {
            return Bytes.wrap((byte[])Hash.digestUsingAlgorithm(input, KECCAK_512).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha3_256(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA3_256);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes32 sha3_256(Bytes input) {
        try {
            return Bytes32.wrap((byte[])Hash.digestUsingAlgorithm(input, SHA3_256).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static byte[] sha3_512(byte[] input) {
        try {
            return Hash.digestUsingAlgorithm(input, SHA3_512);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }

    public static Bytes sha3_512(Bytes input) {
        try {
            return Bytes.wrap((byte[])Hash.digestUsingAlgorithm(input, SHA3_512).toArrayUnsafe());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm should be available but was not", e);
        }
    }
}

