/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.config;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tuweni.config.Configuration;
import org.apache.tuweni.config.ConfigurationError;
import org.apache.tuweni.config.DocumentPosition;
import org.apache.tuweni.config.NoConfigurationPropertyException;
import org.apache.tuweni.config.Schema;
import org.apache.tuweni.config.TomlSerializer;

final class EmptyConfiguration
implements Configuration {
    static final Configuration EMPTY = new EmptyConfiguration(null);
    private final Schema schema;
    private final List<ConfigurationError> errors;

    EmptyConfiguration(@Nullable Schema schema) {
        if (schema != null) {
            this.schema = schema;
            this.errors = schema.validate(EMPTY).collect(Collectors.toList());
        } else {
            this.schema = Schema.EMPTY;
            this.errors = Collections.emptyList();
        }
    }

    @Override
    public List<ConfigurationError> errors() {
        return this.errors;
    }

    @Override
    public void toToml(Appendable appendable) throws IOException {
        new TomlSerializer(this, this.schema).writeTo(appendable);
    }

    @Override
    public Set<String> keySet() {
        return this.schema.defaultsKeySet();
    }

    @Override
    public boolean contains(String key) {
        return this.schema.hasDefault(key);
    }

    @Override
    @Nullable
    public Object get(String key) {
        return this.schema.getDefault(Configuration.canonicalKey(key));
    }

    @Override
    @Nullable
    public DocumentPosition inputPositionOf(String key) {
        return null;
    }

    @Override
    public String getString(String key) {
        return this.getValue(key, this.schema::getDefaultString);
    }

    @Override
    public int getInteger(String key) {
        return this.getValue(key, this.schema::getDefaultInteger);
    }

    @Override
    public long getLong(String key) {
        return this.getValue(key, this.schema::getDefaultLong);
    }

    @Override
    public double getDouble(String key) {
        return this.getValue(key, this.schema::getDefaultDouble);
    }

    @Override
    public boolean getBoolean(String key) {
        return this.getValue(key, this.schema::getDefaultBoolean);
    }

    @Override
    public Map<String, Object> getMap(String key) {
        return this.getValue(key, this.schema::getDefaultMap);
    }

    @Override
    public List<Object> getList(String key) {
        return this.getValue(key, this.schema::getDefaultList);
    }

    @Override
    public List<String> getListOfString(String key) {
        return this.getValue(key, this.schema::getDefaultListOfString);
    }

    @Override
    public List<Integer> getListOfInteger(String key) {
        return this.getValue(key, this.schema::getDefaultListOfInteger);
    }

    @Override
    public List<Long> getListOfLong(String key) {
        return this.getValue(key, this.schema::getDefaultListOfLong);
    }

    @Override
    public List<Double> getListOfDouble(String key) {
        return this.getValue(key, this.schema::getDefaultListOfDouble);
    }

    @Override
    public List<Boolean> getListOfBoolean(String key) {
        return this.getValue(key, this.schema::getDefaultListOfBoolean);
    }

    @Override
    public List<Map<String, Object>> getListOfMap(String key) {
        return this.getValue(key, this.schema::getDefaultListOfMap);
    }

    private <T> T getValue(String key, Function<String, T> defaultGet) {
        String canonicalKey = Configuration.canonicalKey(key);
        T value = defaultGet.apply(canonicalKey);
        if (value != null) {
            return value;
        }
        throw new NoConfigurationPropertyException("No value for property '" + canonicalKey + "'");
    }
}

