/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy.amfilter;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.FilterContainer;
import org.apache.hadoop.http.FilterInitializer;
import org.apache.hadoop.yarn.server.webproxy.amfilter.AmIpFilter;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;

public class AmFilterInitializer
extends FilterInitializer {
    private static final String FILTER_NAME = "AM_PROXY_FILTER";
    private static final String FILTER_CLASS = AmIpFilter.class.getCanonicalName();

    public void initFilter(FilterContainer container, Configuration conf) {
        HashMap<String, String> params = new HashMap<String, String>();
        List proxies = WebAppUtils.getProxyHostsAndPortsForAmFilter((Configuration)conf);
        StringBuilder sb = new StringBuilder();
        for (String proxy : proxies) {
            sb.append(proxy.split(":")[0]).append(",");
        }
        sb.setLength(sb.length() - 1);
        params.put("PROXY_HOSTS", sb.toString());
        String prefix = WebAppUtils.getHttpSchemePrefix((Configuration)conf);
        String proxyBase = this.getApplicationWebProxyBase();
        sb = new StringBuilder();
        for (String proxy : proxies) {
            sb.append(prefix).append(proxy).append(proxyBase).append(",");
        }
        sb.setLength(sb.length() - 1);
        params.put("PROXY_URI_BASES", sb.toString());
        container.addFilter(FILTER_NAME, FILTER_CLASS, params);
    }

    @VisibleForTesting
    protected String getApplicationWebProxyBase() {
        return System.getenv("APPLICATION_WEB_PROXY_BASE");
    }
}

