/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.fluent.Predicate;
import io.kubernetes.client.models.V1LabelSelector;
import io.kubernetes.client.models.V1LabelSelectorBuilder;
import io.kubernetes.client.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.models.V1alpha1AggregationRule;
import io.kubernetes.client.models.V1alpha1AggregationRuleFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class V1alpha1AggregationRuleFluentImpl<A extends V1alpha1AggregationRuleFluent<A>>
extends BaseFluent<A>
implements V1alpha1AggregationRuleFluent<A> {
    private List<V1LabelSelectorBuilder> clusterRoleSelectors;

    public V1alpha1AggregationRuleFluentImpl() {
    }

    public V1alpha1AggregationRuleFluentImpl(V1alpha1AggregationRule instance) {
        this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
    }

    @Override
    public A addToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        this._visitables.get("clusterRoleSelectors").add(index >= 0 ? index : this._visitables.get("clusterRoleSelectors").size(), builder);
        this.clusterRoleSelectors.add(index >= 0 ? index : this.clusterRoleSelectors.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        if (index < 0 || index >= this._visitables.get("clusterRoleSelectors").size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").set(index, builder);
        }
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this.clusterRoleSelectors.add(builder);
        } else {
            this.clusterRoleSelectors.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterRoleSelectors(V1LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterRoleSelectors(Collection<V1LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterRoleSelectors(V1LabelSelector ... items) {
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterRoleSelectors(Collection<V1LabelSelector> items) {
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LabelSelector> getClusterRoleSelectors() {
        return V1alpha1AggregationRuleFluentImpl.build(this.clusterRoleSelectors);
    }

    @Override
    public List<V1LabelSelector> buildClusterRoleSelectors() {
        return V1alpha1AggregationRuleFluentImpl.build(this.clusterRoleSelectors);
    }

    @Override
    public V1LabelSelector buildClusterRoleSelector(int index) {
        return this.clusterRoleSelectors.get(index).build();
    }

    @Override
    public V1LabelSelector buildFirstClusterRoleSelector() {
        return this.clusterRoleSelectors.get(0).build();
    }

    @Override
    public V1LabelSelector buildLastClusterRoleSelector() {
        return this.clusterRoleSelectors.get(this.clusterRoleSelectors.size() - 1).build();
    }

    @Override
    public V1LabelSelector buildMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.apply(item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterRoleSelectors(List<V1LabelSelector> clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this._visitables.get("clusterRoleSelectors").removeAll(this.clusterRoleSelectors);
        }
        if (clusterRoleSelectors != null) {
            this.clusterRoleSelectors = new ArrayList<V1LabelSelectorBuilder>();
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        } else {
            this.clusterRoleSelectors = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterRoleSelectors(V1LabelSelector ... clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this.clusterRoleSelectors.clear();
        }
        if (clusterRoleSelectors != null) {
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterRoleSelectors() {
        return this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty();
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
        return new ClusterRoleSelectorsNestedImpl();
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(V1LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index, V1LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(index, item);
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
        if (this.clusterRoleSelectors.size() <= index) {
            throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
        if (this.clusterRoleSelectors.size() == 0) {
            throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(0, this.buildClusterRoleSelector(0));
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
        int index = this.clusterRoleSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterRoleSelectors.size(); ++i) {
            if (!predicate.apply(this.clusterRoleSelectors.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1alpha1AggregationRuleFluentImpl that = (V1alpha1AggregationRuleFluentImpl)o;
        return !(this.clusterRoleSelectors != null ? !this.clusterRoleSelectors.equals(that.clusterRoleSelectors) : that.clusterRoleSelectors != null);
    }

    public class ClusterRoleSelectorsNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<N>>
    implements V1alpha1AggregationRuleFluent.ClusterRoleSelectorsNested<N>,
    Nested<N> {
        private final V1LabelSelectorBuilder builder;
        private final int index;

        ClusterRoleSelectorsNestedImpl(int index, V1LabelSelector item) {
            this.index = index;
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        ClusterRoleSelectorsNestedImpl() {
            this.index = -1;
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1AggregationRuleFluentImpl.this.setToClusterRoleSelectors(this.index, this.builder.build());
        }

        @Override
        public N endClusterRoleSelector() {
            return this.and();
        }
    }
}

